/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.adapter;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import java.util.ArrayList;

public class AppConfigChoiceAdapter
extends BaseAdapter
implements ListAdapter {
    private Context context;
    private ArrayList<String> choices = new ArrayList();

    public AppConfigChoiceAdapter(Context context) {
        this.context = context;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int i) {
        return true;
    }

    public int getCount() {
        return this.choices.size();
    }

    public Object getItem(int i) {
        return this.choices.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public boolean hasStableIds() {
        return false;
    }

    private int dip(int pixels) {
        return (int)(this.context.getResources().getDisplayMetrics().density * (float)pixels);
    }

    private Drawable generateSelectionBackgroundDrawable() {
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16842908}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor(this.context, "app_config_background")));
        drawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor(this.context, "app_config_background")));
        drawable.addState(new int[]{16842910}, (Drawable)new ColorDrawable(-1));
        drawable.addState(new int[]{-16842910}, (Drawable)new ColorDrawable(-1));
        return drawable;
    }

    private View generateView() {
        ViewHolder viewHolder = new ViewHolder();
        LinearLayout createdView = new LinearLayout(this.context);
        createdView.setOrientation(1);
        createdView.setBackgroundColor(-1);
        viewHolder.labelView = new TextView(this.context);
        createdView.addView((View)viewHolder.labelView);
        viewHolder.dividerView = new View(this.context);
        createdView.addView(viewHolder.dividerView);
        viewHolder.labelView.setGravity(16);
        viewHolder.labelView.setMinimumHeight(this.dip(60));
        viewHolder.labelView.setPadding(this.dip(12), this.dip(12), this.dip(12), this.dip(12));
        viewHolder.labelView.setTextSize(18.0f);
        if (Build.VERSION.SDK_INT < 16) {
            viewHolder.labelView.setBackgroundDrawable(this.generateSelectionBackgroundDrawable());
        } else {
            viewHolder.labelView.setBackground(this.generateSelectionBackgroundDrawable());
        }
        viewHolder.dividerView.setBackgroundColor(AppConfigResourceHelper.getColor(this.context, "app_config_list_divider_line"));
        viewHolder.dividerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        ((LinearLayout.LayoutParams)viewHolder.dividerView.getLayoutParams()).setMargins(this.dip(12), 0, 0, 0);
        createdView.setTag((Object)viewHolder);
        return createdView;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        String choice = (String)this.getItem(i);
        if (view == null) {
            view = this.generateView();
        }
        if (view != null) {
            ViewHolder viewHolder = (ViewHolder)view.getTag();
            if (viewHolder.labelView != null) {
                viewHolder.labelView.setText((CharSequence)choice);
            }
            if (viewHolder.dividerView != null) {
                String nextChoice = null;
                if (i < this.choices.size() - 1) {
                    nextChoice = (String)this.getItem(i + 1);
                }
                viewHolder.dividerView.setVisibility(nextChoice != null ? 0 : 8);
            }
        }
        return view;
    }

    public void setChoices(ArrayList<String> choices) {
        this.choices = choices;
        this.notifyDataSetChanged();
    }

    public static class ViewHolder {
        public TextView labelView = null;
        public View dividerView = null;
    }
}

