/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import com.crescentflare.appconfig.activity.AppConfigStringChoiceActivity;
import com.crescentflare.appconfig.activity.EditAppConfigActivity;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import com.crescentflare.appconfig.helper.AppConfigViewHelper;
import com.crescentflare.appconfig.manager.AppConfigStorage;
import com.crescentflare.appconfig.model.AppConfigBaseModel;
import com.crescentflare.appconfig.model.AppConfigStorageItem;
import com.crescentflare.appconfig.plugin.AppConfigPlugin;
import com.crescentflare.appconfig.view.AppConfigCellList;
import com.crescentflare.appconfig.view.AppConfigClickableCell;
import com.crescentflare.appconfig.view.AppConfigEditableCell;
import com.crescentflare.appconfig.view.AppConfigSimpleCell;
import com.crescentflare.appconfig.view.AppConfigSwitchCell;
import java.util.ArrayList;

public class ManageAppConfigActivity
extends AppCompatActivity
implements AppConfigStorage.ChangedConfigListener {
    private static final int RESULT_CODE_CUSTOM_COPY_FROM = 1000;
    private static final int RESULT_CODE_EDIT_CONFIG = 1001;
    private static final int RESULT_CODE_SELECT_ENUM = 1004;
    private ArrayList<View> fieldViews = new ArrayList();
    private LinearLayout layout = null;
    private AppConfigCellList managingView = null;
    private LinearLayout spinnerView = null;
    private AppConfigStorageItem initialEditValues = null;
    private AppConfigStorageItem latestEditValues = null;
    private int buildNr = -1;

    public static Intent newInstance(Context context) {
        return new Intent(context, ManageAppConfigActivity.class);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!AppConfigStorage.instance.isInitialized()) {
            this.finish();
            return;
        }
        try {
            PackageInfo info;
            PackageManager manager = this.getPackageManager();
            if (manager != null && (info = manager.getPackageInfo(this.getPackageName(), 0)) != null) {
                this.buildNr = info.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.layout = this.createContentView();
        this.setTitle(AppConfigResourceHelper.getString((Context)this, "app_config_title_list"));
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeButtonEnabled(true);
        }
        this.setContentView((View)this.layout);
        AppConfigStorage.instance.loadFromSource((Context)this, new Runnable(){

            @Override
            public void run() {
                ManageAppConfigActivity.this.populateContent();
                ManageAppConfigActivity.this.initialEditValues = ManageAppConfigActivity.this.fetchEditedValues();
                ManageAppConfigActivity.this.latestEditValues = ManageAppConfigActivity.this.initialEditValues;
            }
        });
    }

    public static void startWithResult(Activity fromActivity, int resultCode) {
        fromActivity.startActivityForResult(ManageAppConfigActivity.newInstance((Context)fromActivity), resultCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        int index;
        String resultString;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1000 && resultCode == -1) {
            String resultString2 = data.getStringExtra("ARG_INTENT_RESULT_SELECTED_STRING");
            if (resultString2.length() > 0) {
                EditAppConfigActivity.startWithResult((Activity)this, resultString2, true, 1001);
            }
        } else if (requestCode == 1001 && resultCode == -1) {
            this.populateContent();
        } else if (requestCode >= 1004 && requestCode < 2004 && resultCode == -1 && (resultString = data.getStringExtra("ARG_INTENT_RESULT_SELECTED_STRING")).length() > 0 && (index = requestCode - 1004) < this.fieldViews.size() && this.fieldViews.get(index) instanceof AppConfigClickableCell) {
            ((AppConfigClickableCell)this.fieldViews.get(index)).setText(this.fieldViews.get(index).getTag() + ": " + resultString);
        }
    }

    public void finish() {
        boolean hasChange = false;
        if (this.initialEditValues != null) {
            boolean bl = hasChange = !this.fetchEditedValues().equals(this.initialEditValues);
        }
        if (hasChange) {
            this.saveGlobalData();
        }
        super.finish();
    }

    protected void onPause() {
        super.onPause();
        AppConfigStorage.instance.removeChangedConfigListener(this);
    }

    protected void onResume() {
        super.onResume();
        if (this.initialEditValues != null) {
            this.latestEditValues = this.fetchEditedValues();
        }
        this.populateContent();
        AppConfigStorage.instance.addChangedConfigListener(this);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onChangedConfig() {
        this.populateContent();
    }

    private int dp(int dp) {
        return AppConfigViewHelper.dp(dp);
    }

    private AppConfigSimpleCell generateInfoView(String infoLabel, String infoValue) {
        AppConfigSimpleCell cellView = new AppConfigSimpleCell((Context)this);
        cellView.setText(infoLabel + ": " + infoValue);
        return cellView;
    }

    private AppConfigClickableCell generateButtonView(String action, boolean edited) {
        return this.generateButtonView(null, action, edited);
    }

    private AppConfigClickableCell generateButtonView(String label, String setting, boolean edited) {
        AppConfigClickableCell cellView = new AppConfigClickableCell((Context)this);
        cellView.setTag(label);
        cellView.setText(setting);
        if (edited) {
            cellView.setValue(AppConfigResourceHelper.getString((Context)this, "app_config_item_edited"));
        }
        return cellView;
    }

    private AppConfigEditableCell generateEditTextView(String label, String setting, boolean limitNumbers) {
        AppConfigEditableCell editView = new AppConfigEditableCell((Context)this);
        editView.setDescription(label);
        editView.setValue(setting);
        editView.setTag(label);
        editView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ManageAppConfigActivity.this.supportInvalidateOptionsMenu();
            }
        });
        editView.setNumberLimit(limitNumbers);
        return editView;
    }

    private AppConfigSwitchCell generateSwitchView(String label, boolean setting) {
        AppConfigSwitchCell switchView = new AppConfigSwitchCell((Context)this);
        LinearLayout.LayoutParams switchViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        switchView.setLayoutParams((ViewGroup.LayoutParams)switchViewLayoutParams);
        switchView.setText(label);
        switchView.setChecked(setting);
        switchView.setTag(label);
        switchView.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ManageAppConfigActivity.this.supportInvalidateOptionsMenu();
            }
        });
        return switchView;
    }

    private LinearLayout createContentView() {
        this.layout = new LinearLayout((Context)this);
        this.layout.setOrientation(1);
        if (this.getSupportActionBar() == null) {
            Toolbar bar = new Toolbar((Context)this);
            this.layout.addView((View)bar, 0);
            this.setSupportActionBar(bar);
        }
        FrameLayout container = new FrameLayout((Context)this);
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        container.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_background"));
        this.layout.addView((View)container);
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.managingView = new AppConfigCellList((Context)this);
        this.managingView.setVisibility(8);
        scrollView.addView((View)this.managingView);
        container.addView((View)scrollView);
        this.spinnerView = new LinearLayout((Context)this);
        this.spinnerView.setBackgroundColor(-1);
        this.spinnerView.setGravity(17);
        this.spinnerView.setOrientation(1);
        this.spinnerView.setPadding(this.dp(8), this.dp(8), this.dp(8), this.dp(8));
        container.addView((View)this.spinnerView);
        ProgressBar iconView = new ProgressBar((Context)this);
        this.spinnerView.addView((View)iconView);
        TextView progressTextView = new TextView((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.setMargins(0, this.dp(12), 0, 0);
        progressTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressTextView.setGravity(1);
        progressTextView.setText((CharSequence)AppConfigResourceHelper.getString((Context)this, "app_config_loading"));
        this.spinnerView.addView((View)progressTextView);
        if (this.buildNr > 0) {
            TextView progressBuildView = new TextView((Context)this);
            LinearLayout.LayoutParams buildLayoutParams = new LinearLayout.LayoutParams(-1, -2);
            buildLayoutParams.setMargins(0, this.dp(2), 0, 0);
            progressBuildView.setLayoutParams((ViewGroup.LayoutParams)buildLayoutParams);
            progressBuildView.setGravity(1);
            progressBuildView.setText((CharSequence)("(" + AppConfigResourceHelper.getString((Context)this, "app_config_field_build").toLowerCase() + ": " + this.buildNr + ")"));
            this.spinnerView.addView((View)progressBuildView);
        }
        return this.layout;
    }

    private void generateEditingContent(String category, ArrayList<String> values, AppConfigStorageItem config, AppConfigBaseModel baseModel) {
        String title = AppConfigResourceHelper.getString((Context)this, "app_config_header_global_prefix");
        if (category != null) {
            title = category.length() > 0 ? title + ": " + category : title + ": " + AppConfigResourceHelper.getString((Context)this, "app_config_header_edit_other");
        }
        this.managingView.startSection(title);
        ArrayList<String> editValues = new ArrayList<String>();
        ArrayList<Object> editObjects = new ArrayList<Object>();
        for (final String value : values) {
            boolean belongsToCategory = true;
            if (category != null && baseModel != null) {
                belongsToCategory = baseModel.valueBelongsToCategory(value, category);
            }
            if (!belongsToCategory || value.equals("name")) continue;
            editValues.add(value);
            editObjects.add(baseModel != null ? baseModel.getCurrentValue(value) : config.get(value));
        }
        for (int i = 0; i < editValues.size(); ++i) {
            String value;
            value = (String)editValues.get(i);
            FrameLayout layoutView = null;
            final Object result = editObjects.get(i);
            if (result == null) continue;
            if (result instanceof Boolean) {
                layoutView = this.generateSwitchView(value, (Boolean)result);
            } else if (result.getClass().isEnum()) {
                final int index = this.fieldViews.size();
                layoutView = this.generateButtonView(value, value + ": " + result.toString(), false);
                layoutView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ?[] constants = result.getClass().getEnumConstants();
                        ArrayList<String> enumValues = new ArrayList<String>();
                        for (int i = 0; i < constants.length; ++i) {
                            enumValues.add(constants[i].toString());
                        }
                        if (enumValues.size() > 0) {
                            AppConfigStringChoiceActivity.startWithResult((Activity)ManageAppConfigActivity.this, AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_title_choose_enum_prefix") + " " + value, AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_header_choose_enum"), enumValues, 1004 + index);
                        }
                    }
                });
            } else if (result instanceof Integer || result instanceof Long) {
                layoutView = this.generateEditTextView(value, "" + result, true);
            } else if (result instanceof String) {
                layoutView = this.generateEditTextView(value, (String)result, false);
            }
            if (layoutView == null) continue;
            this.managingView.addSectionItem((View)layoutView);
            this.fieldViews.add(layoutView.findViewWithTag((Object)value));
        }
        this.managingView.endSection();
    }

    private void populateContent() {
        this.spinnerView.setVisibility(AppConfigStorage.instance.isLoaded() ? 8 : 0);
        this.managingView.setVisibility(AppConfigStorage.instance.isLoaded() ? 0 : 8);
        if (!AppConfigStorage.instance.isLoaded()) {
            return;
        }
        this.managingView.removeAllViews();
        this.fieldViews.clear();
        ArrayList<String> configs = AppConfigStorage.instance.configList();
        if (configs.size() > 0) {
            Object buttonName;
            this.managingView.startSection(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_last_selection"));
            boolean isOverride = false;
            boolean hasLastSelection = false;
            if (AppConfigStorage.instance.getSelectedConfig() != null) {
                buttonName = AppConfigStorage.instance.getSelectedConfigName();
                isOverride = AppConfigStorage.instance.isConfigOverride((String)buttonName);
                hasLastSelection = true;
            } else {
                buttonName = AppConfigResourceHelper.getString((Context)this, "app_config_item_none");
            }
            AppConfigClickableCell selectButton = this.generateButtonView((String)buttonName, isOverride);
            selectButton.setId(AppConfigResourceHelper.getIdentifier((Context)this, "app_config_activity_manage_select_current"));
            this.managingView.addSectionItem((View)selectButton);
            if (hasLastSelection) {
                selectButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ManageAppConfigActivity.this.setResult(-1);
                        ManageAppConfigActivity.this.finish();
                    }
                });
                Object configName = buttonName;
                selectButton.setOnLongClickListener(new View.OnLongClickListener((String)configName){
                    final /* synthetic */ String val$configName;
                    {
                        this.val$configName = string;
                    }

                    public boolean onLongClick(View v) {
                        EditAppConfigActivity.startWithResult((Activity)ManageAppConfigActivity.this, this.val$configName, false, 1001);
                        return true;
                    }
                });
            }
            this.managingView.endSection();
        }
        if (configs.size() > 0) {
            this.managingView.startSection(AppConfigResourceHelper.getString((Context)this, "app_config_header_list"));
            for (final String configName : configs) {
                AppConfigClickableCell configButton = this.generateButtonView(configName, AppConfigStorage.instance.isConfigOverride(configName));
                configButton.setTag("config: " + configName);
                this.managingView.addSectionItem((View)configButton);
                configButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ManageAppConfigActivity.this.saveGlobalData();
                        AppConfigStorage.instance.selectConfig((Context)ManageAppConfigActivity.this, configName);
                        ManageAppConfigActivity.this.setResult(-1);
                        ManageAppConfigActivity.this.finish();
                    }
                });
                configButton.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        EditAppConfigActivity.startWithResult((Activity)ManageAppConfigActivity.this, configName, false, 1001);
                        return true;
                    }
                });
            }
            this.managingView.endSection();
        }
        if (configs.size() > 0) {
            this.managingView.startSection(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_custom"));
            ArrayList<String> customConfigs = AppConfigStorage.instance.customConfigList();
            for (final String configName : customConfigs) {
                if (!AppConfigStorage.instance.isCustomConfig(configName)) continue;
                AppConfigClickableCell configButton = this.generateButtonView(configName, false);
                configButton.setTag("config: " + configName);
                this.managingView.addSectionItem((View)configButton);
                configButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ManageAppConfigActivity.this.saveGlobalData();
                        AppConfigStorage.instance.selectConfig((Context)ManageAppConfigActivity.this, configName);
                        ManageAppConfigActivity.this.setResult(-1);
                        ManageAppConfigActivity.this.finish();
                    }
                });
                configButton.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        EditAppConfigActivity.startWithResult((Activity)ManageAppConfigActivity.this, configName, false, 1001);
                        return true;
                    }
                });
            }
            AppConfigClickableCell newButton = this.generateButtonView(AppConfigResourceHelper.getString((Context)this, "app_config_action_add"), false);
            newButton.setId(AppConfigResourceHelper.getIdentifier((Context)this, "app_config_activity_manage_new_custom"));
            this.managingView.addSectionItem((View)newButton);
            newButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ArrayList<String> configs = AppConfigStorage.instance.configList();
                    AppConfigStringChoiceActivity.startWithResult((Activity)ManageAppConfigActivity.this, AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_title_edit_new"), AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_header_choose_custom_copy"), configs, 1000);
                }
            });
            this.managingView.endSection();
        }
        AppConfigStorageItem config = AppConfigStorage.instance.getGlobalConfig();
        if (this.latestEditValues != null) {
            config = this.latestEditValues;
        }
        ArrayList<String> values = config.valueList();
        ArrayList<Object> categories = new ArrayList();
        AppConfigBaseModel baseModel = null;
        if (AppConfigStorage.instance.getConfigManager() != null) {
            baseModel = AppConfigStorage.instance.getConfigManager().getBaseModelInstance();
            baseModel.applyCustomSettings("Global", config);
            values = AppConfigStorage.instance.getConfigManager().getBaseModelInstance().globalValueList();
            categories = baseModel.getGlobalCategories();
        }
        if (values.size() > 0) {
            if (categories.size() > 0) {
                for (String category : categories) {
                    this.generateEditingContent(category, values, config, baseModel);
                }
            } else {
                this.generateEditingContent(null, values, config, baseModel);
            }
        }
        if (AppConfigStorage.instance.getConfigManager() != null && AppConfigStorage.instance.getConfigManager().getPlugins() != null && AppConfigStorage.instance.getConfigManager().getPlugins().size() > 0) {
            this.managingView.startSection(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_plugins"));
            for (final AppConfigPlugin plugin : AppConfigStorage.instance.getConfigManager().getPlugins()) {
                String buttonText = plugin.displayName();
                if (buttonText != null) {
                    if (plugin.displayValue() != null && plugin.displayValue().length() > 0) {
                        buttonText = buttonText + ": " + plugin.displayValue();
                    }
                } else {
                    buttonText = plugin.displayValue();
                }
                AppConfigClickableCell pluginButton = this.generateButtonView(buttonText, false);
                pluginButton.setTag("plugin: " + plugin.displayName());
                this.managingView.addSectionItem((View)pluginButton);
                if (!plugin.canInteract()) continue;
                pluginButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        plugin.interact((Activity)ManageAppConfigActivity.this);
                        ManageAppConfigActivity.this.populateContent();
                    }
                });
            }
            this.managingView.endSection();
        }
        this.managingView.startSection(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_build_info"));
        this.managingView.addSectionItem((View)this.generateInfoView(AppConfigResourceHelper.getString((Context)this, "app_config_field_build"), "" + this.buildNr));
        this.managingView.addSectionItem((View)this.generateInfoView(AppConfigResourceHelper.getString((Context)this, "app_config_field_api_level"), "" + Build.VERSION.SDK_INT));
        this.managingView.endSection();
    }

    private AppConfigStorageItem fetchEditedValues() {
        AppConfigStorageItem item = new AppConfigStorageItem();
        for (View view : this.fieldViews) {
            if (view.getTag() == null) break;
            if (view instanceof AppConfigEditableCell) {
                if (((AppConfigEditableCell)view).isNumberLimit()) {
                    long number = 0L;
                    try {
                        number = Long.parseLong(((AppConfigEditableCell)view).getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    item.putLong((String)view.getTag(), number);
                    continue;
                }
                item.putString((String)view.getTag(), ((AppConfigEditableCell)view).getValue());
                continue;
            }
            if (view instanceof AppConfigSwitchCell) {
                item.putBoolean((String)view.getTag(), ((AppConfigSwitchCell)view).isChecked());
                continue;
            }
            if (!(view instanceof AppConfigClickableCell)) continue;
            item.putString((String)view.getTag(), ((AppConfigClickableCell)view).getText().replace(view.getTag() + ": ", ""));
        }
        return item;
    }

    private void saveGlobalData() {
        AppConfigStorageItem item = this.fetchEditedValues();
        AppConfigStorage.instance.updateGlobalConfig((Context)this, item);
    }
}

