/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import com.crescentflare.appconfig.R;
import com.crescentflare.appconfig.activity.AppConfigStringChoiceActivity;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import com.crescentflare.appconfig.helper.AppConfigViewHelper;
import com.crescentflare.appconfig.manager.AppConfigStorage;
import com.crescentflare.appconfig.model.AppConfigBaseModel;
import com.crescentflare.appconfig.model.AppConfigStorageItem;
import com.crescentflare.appconfig.view.AppConfigCellList;
import com.crescentflare.appconfig.view.AppConfigClickableCell;
import com.crescentflare.appconfig.view.AppConfigEditableCell;
import com.crescentflare.appconfig.view.AppConfigSwitchCell;
import java.util.ArrayList;

public class EditAppConfigActivity
extends AppCompatActivity {
    private static final String ARG_CONFIG_NAME = "ARG_CONFIG_NAME";
    private static final String ARG_CREATE_CUSTOM = "ARG_CREATE_CUSTOM";
    private static final int RESULT_CODE_SELECT_ENUM = 1004;
    private ArrayList<View> fieldViews = new ArrayList();
    private LinearLayout layout = null;
    private AppConfigCellList editingView = null;
    private LinearLayout spinnerView = null;
    private AppConfigStorageItem initialEditValues = null;

    public static Intent newInstance(Context context, String config, boolean createCustom) {
        Intent intent = new Intent(context, EditAppConfigActivity.class);
        intent.putExtra(ARG_CONFIG_NAME, config);
        intent.putExtra(ARG_CREATE_CUSTOM, createCustom);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.layout = this.createContentView();
        this.setTitle(AppConfigResourceHelper.getString((Context)this, this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false) ? "app_config_title_edit_new" : "app_config_title_edit"));
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeButtonEnabled(true);
        }
        this.setContentView((View)this.layout);
        AppConfigStorage.instance.loadFromSource((Context)this, new Runnable(){

            @Override
            public void run() {
                EditAppConfigActivity.this.populateContent();
                EditAppConfigActivity.this.initialEditValues = EditAppConfigActivity.this.fetchEditedValues();
            }
        });
    }

    public static void startWithResult(Activity fromActivity, String config, boolean createCustom, int resultCode) {
        fromActivity.startActivityForResult(EditAppConfigActivity.newInstance((Context)fromActivity, config, createCustom), resultCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode >= 1004 && requestCode < 2004 && resultCode == -1) {
            int index;
            String resultString = data.getStringExtra("ARG_INTENT_RESULT_SELECTED_STRING");
            if (resultString.length() > 0 && (index = requestCode - 1004) < this.fieldViews.size() && this.fieldViews.get(index) instanceof AppConfigClickableCell) {
                ((AppConfigClickableCell)this.fieldViews.get(index)).setText(this.fieldViews.get(index).getTag() + ": " + resultString);
            }
            this.supportInvalidateOptionsMenu();
        }
    }

    public void onBackPressed() {
        boolean hasChange = false;
        if (this.initialEditValues != null) {
            boolean bl = hasChange = !this.fetchEditedValues().equals(this.initialEditValues);
        }
        if (hasChange) {
            AlertDialog.Builder alert = new AlertDialog.Builder((Context)this).setTitle((CharSequence)AppConfigResourceHelper.getString((Context)this, "app_config_title_dialog_confirm_save_changes")).setCancelable(true).setPositiveButton((CharSequence)AppConfigResourceHelper.getString((Context)this, "app_config_action_confirm"), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    EditAppConfigActivity.this.saveData();
                }
            }).setNegativeButton((CharSequence)AppConfigResourceHelper.getString((Context)this, "app_config_action_deny"), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    EditAppConfigActivity.this.setResult(0);
                    EditAppConfigActivity.this.finish();
                }
            });
            alert.show();
        } else {
            super.onBackPressed();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.edit, menu2);
        if (menu2 == null) {
            return false;
        }
        menu2.findItem(R.id.app_config_menu_save).setVisible(!this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false));
        menu2.findItem(R.id.app_config_menu_create).setVisible(this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false));
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        boolean hasChange = false;
        if (this.initialEditValues != null) {
            hasChange = !this.fetchEditedValues().equals(this.initialEditValues);
        }
        menu2.findItem(R.id.app_config_menu_save).setEnabled(hasChange);
        menu2.findItem(R.id.app_config_menu_create).setEnabled(hasChange);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.app_config_menu_create || item.getItemId() == R.id.app_config_menu_save) {
            this.saveData();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private int dp(int dp) {
        return AppConfigViewHelper.dp(dp);
    }

    private AppConfigClickableCell generateButtonView(String action) {
        return this.generateButtonView(null, action);
    }

    private AppConfigClickableCell generateButtonView(String label, String setting) {
        AppConfigClickableCell cellView = new AppConfigClickableCell((Context)this);
        cellView.setTag(label);
        cellView.setText(setting);
        return cellView;
    }

    private AppConfigEditableCell generateEditTextView(String label, String setting, boolean limitNumbers) {
        AppConfigEditableCell editView = new AppConfigEditableCell((Context)this);
        editView.setDescription(label);
        editView.setValue(setting);
        editView.setTag(label);
        editView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                EditAppConfigActivity.this.supportInvalidateOptionsMenu();
            }
        });
        editView.setNumberLimit(limitNumbers);
        return editView;
    }

    private AppConfigSwitchCell generateSwitchView(String label, boolean setting) {
        AppConfigSwitchCell switchView = new AppConfigSwitchCell((Context)this);
        LinearLayout.LayoutParams switchViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        switchView.setLayoutParams((ViewGroup.LayoutParams)switchViewLayoutParams);
        switchView.setText(label);
        switchView.setChecked(setting);
        switchView.setTag(label);
        switchView.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                EditAppConfigActivity.this.supportInvalidateOptionsMenu();
            }
        });
        return switchView;
    }

    private LinearLayout createContentView() {
        this.layout = new LinearLayout((Context)this);
        this.layout.setOrientation(1);
        if (this.getSupportActionBar() == null) {
            Toolbar bar = new Toolbar((Context)this);
            this.layout.addView((View)bar, 0);
            this.setSupportActionBar(bar);
        }
        FrameLayout container = new FrameLayout((Context)this);
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        container.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_background"));
        this.layout.addView((View)container);
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.editingView = new AppConfigCellList((Context)this);
        this.editingView.setVisibility(8);
        scrollView.addView((View)this.editingView);
        container.addView((View)scrollView);
        this.spinnerView = new LinearLayout((Context)this);
        this.spinnerView.setBackgroundColor(-1);
        this.spinnerView.setGravity(17);
        this.spinnerView.setOrientation(1);
        this.spinnerView.setPadding(this.dp(8), this.dp(8), this.dp(8), this.dp(8));
        container.addView((View)this.spinnerView);
        ProgressBar iconView = new ProgressBar((Context)this);
        this.spinnerView.addView((View)iconView);
        TextView progressTextView = new TextView((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.setMargins(0, this.dp(12), 0, 0);
        progressTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressTextView.setGravity(1);
        progressTextView.setText((CharSequence)AppConfigResourceHelper.getString((Context)this, "app_config_loading"));
        this.spinnerView.addView((View)progressTextView);
        return this.layout;
    }

    private void generateEditingContent(String category, ArrayList<String> values, AppConfigStorageItem config, AppConfigBaseModel baseModel) {
        String title;
        LinearLayout fieldEditLayout = new LinearLayout((Context)this);
        String string = title = this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false) ? AppConfigResourceHelper.getString((Context)this, "app_config_header_edit_new") : this.getIntent().getStringExtra(ARG_CONFIG_NAME);
        if (category != null) {
            title = category.length() > 0 ? title + ": " + category : title + ": " + AppConfigResourceHelper.getString((Context)this, "app_config_header_edit_other");
        }
        this.editingView.startSection(title);
        ArrayList<String> editValues = new ArrayList<String>();
        ArrayList<Object> editObjects = new ArrayList<Object>();
        for (final String value : values) {
            boolean belongsToCategory = true;
            if (category != null && baseModel != null) {
                belongsToCategory = baseModel.valueBelongsToCategory(value, category);
            }
            if (!belongsToCategory || value.equals("name")) continue;
            editValues.add(value);
            editObjects.add(baseModel != null ? baseModel.getCurrentValue(value) : config.get(value));
        }
        for (int i = 0; i < editValues.size(); ++i) {
            String value;
            value = (String)editValues.get(i);
            FrameLayout layoutView = null;
            Object previousResult = i > 0 ? editObjects.get(i - 1) : null;
            final Object result = editObjects.get(i);
            if (result == null) continue;
            if (result instanceof Boolean) {
                layoutView = this.generateSwitchView(value, (Boolean)result);
            } else if (result.getClass().isEnum()) {
                final int index = this.fieldViews.size();
                layoutView = this.generateButtonView(value, value + ": " + result.toString());
                layoutView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ?[] constants = result.getClass().getEnumConstants();
                        ArrayList<String> enumValues = new ArrayList<String>();
                        for (int i = 0; i < constants.length; ++i) {
                            enumValues.add(constants[i].toString());
                        }
                        if (enumValues.size() > 0) {
                            AppConfigStringChoiceActivity.startWithResult((Activity)EditAppConfigActivity.this, AppConfigResourceHelper.getString((Context)EditAppConfigActivity.this, "app_config_title_choose_enum_prefix") + " " + value, AppConfigResourceHelper.getString((Context)EditAppConfigActivity.this, "app_config_header_choose_enum"), enumValues, 1004 + index);
                        }
                    }
                });
            } else if (result instanceof Integer || result instanceof Long) {
                layoutView = this.generateEditTextView(value, "" + result, true);
            } else if (result instanceof String) {
                layoutView = this.generateEditTextView(value, (String)result, false);
            }
            if (layoutView == null) continue;
            this.editingView.addSectionItem((View)layoutView);
            this.fieldViews.add(layoutView.findViewWithTag((Object)value));
        }
        this.editingView.endSection();
    }

    private void populateContent() {
        this.spinnerView.setVisibility(AppConfigStorage.instance.isLoaded() ? 8 : 0);
        this.editingView.setVisibility(AppConfigStorage.instance.isLoaded() ? 0 : 8);
        if (!AppConfigStorage.instance.isLoaded()) {
            return;
        }
        this.editingView.removeAllViews();
        this.fieldViews.clear();
        AppConfigStorageItem config = AppConfigStorage.instance.getConfigNotNull(this.getIntent().getStringExtra(ARG_CONFIG_NAME));
        ArrayList<String> values = config.valueList();
        ArrayList<Object> categories = new ArrayList();
        AppConfigBaseModel baseModel = null;
        if (AppConfigStorage.instance.getConfigManager() != null) {
            baseModel = AppConfigStorage.instance.getConfigManager().getBaseModelInstance();
            baseModel.applyCustomSettings(this.getIntent().getStringExtra(ARG_CONFIG_NAME), config);
            values = AppConfigStorage.instance.getConfigManager().getBaseModelInstance().configurationValueList();
            categories = baseModel.getConfigurationCategories();
        }
        if (AppConfigStorage.instance.isCustomConfig(this.getIntent().getStringExtra(ARG_CONFIG_NAME)) || this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false)) {
            Object name = this.getIntent().getStringExtra(ARG_CONFIG_NAME);
            if (this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false)) {
                name = (String)name + " " + AppConfigResourceHelper.getString((Context)this, "app_config_modifier_copy");
            }
            AppConfigEditableCell editableCell = this.generateEditTextView("name", (String)name, false);
            this.editingView.startSection(AppConfigResourceHelper.getString((Context)this, "app_config_header_edit_name"));
            this.editingView.addSectionItem((View)editableCell);
            this.editingView.endSection();
            this.fieldViews.add(editableCell.findViewWithTag("name"));
        }
        if (categories.size() > 0) {
            for (String category : categories) {
                this.generateEditingContent(category, values, config, baseModel);
            }
        } else {
            this.generateEditingContent(null, values, config, baseModel);
        }
        this.editingView.startSection(AppConfigResourceHelper.getString((Context)this, "app_config_header_edit_actions"));
        if (this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false)) {
            AppConfigClickableCell createButton = this.generateButtonView(AppConfigResourceHelper.getString((Context)this, "app_config_action_ok_edit_new"));
            createButton.setId(AppConfigResourceHelper.getIdentifier((Context)this, "app_config_activity_edit_save"));
            this.editingView.addSectionItem((View)createButton);
            createButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EditAppConfigActivity.this.saveData();
                }
            });
        } else {
            AppConfigClickableCell saveButton = this.generateButtonView(AppConfigResourceHelper.getString((Context)this, "app_config_action_ok_edit"));
            saveButton.setId(AppConfigResourceHelper.getIdentifier((Context)this, "app_config_activity_edit_save"));
            this.editingView.addSectionItem((View)saveButton);
            saveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EditAppConfigActivity.this.saveData();
                }
            });
            String buttonText = AppConfigResourceHelper.getString((Context)this, AppConfigStorage.instance.isCustomConfig(this.getIntent().getStringExtra(ARG_CONFIG_NAME)) ? "app_config_action_delete" : "app_config_action_restore");
            AppConfigClickableCell deleteButton = this.generateButtonView(buttonText);
            deleteButton.setId(AppConfigResourceHelper.getIdentifier((Context)this, "app_config_activity_edit_clear"));
            this.editingView.addSectionItem((View)deleteButton);
            deleteButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String configName = EditAppConfigActivity.this.getIntent().getStringExtra(EditAppConfigActivity.ARG_CONFIG_NAME);
                    if (AppConfigStorage.instance.isCustomConfig(configName) || AppConfigStorage.instance.isConfigOverride(configName)) {
                        AppConfigStorage.instance.removeConfig(configName);
                        AppConfigStorage.instance.synchronizeCustomConfigWithPreferences((Context)EditAppConfigActivity.this, EditAppConfigActivity.this.getIntent().getStringExtra(EditAppConfigActivity.ARG_CONFIG_NAME));
                        EditAppConfigActivity.this.setResult(-1);
                    } else {
                        EditAppConfigActivity.this.setResult(0);
                    }
                    EditAppConfigActivity.this.finish();
                }
            });
        }
        AppConfigClickableCell cancelButton = this.generateButtonView(AppConfigResourceHelper.getString((Context)this, "app_config_action_cancel"));
        cancelButton.setId(AppConfigResourceHelper.getIdentifier((Context)this, "app_config_activity_edit_cancel"));
        this.editingView.addSectionItem((View)cancelButton);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditAppConfigActivity.this.onBackPressed();
            }
        });
        this.editingView.endSection();
    }

    private AppConfigStorageItem fetchEditedValues() {
        AppConfigStorageItem item = new AppConfigStorageItem();
        String name = this.getIntent().getStringExtra(ARG_CONFIG_NAME);
        for (View view : this.fieldViews) {
            if (view.getTag() == null) break;
            if (view.getTag().equals("name")) {
                if (!(view instanceof AppConfigEditableCell)) continue;
                name = ((AppConfigEditableCell)view).getValue();
                continue;
            }
            if (view instanceof AppConfigEditableCell) {
                if (((AppConfigEditableCell)view).isNumberLimit()) {
                    long number = 0L;
                    try {
                        number = Long.parseLong(((AppConfigEditableCell)view).getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    item.putLong((String)view.getTag(), number);
                    continue;
                }
                item.putString((String)view.getTag(), ((AppConfigEditableCell)view).getValue());
                continue;
            }
            if (view instanceof AppConfigSwitchCell) {
                item.putBoolean((String)view.getTag(), ((AppConfigSwitchCell)view).isChecked());
                continue;
            }
            if (!(view instanceof AppConfigClickableCell)) continue;
            item.putString((String)view.getTag(), ((AppConfigClickableCell)view).getText().replace(view.getTag() + ": ", ""));
        }
        if (name.length() > 0) {
            item.putString("name", name);
        }
        return item;
    }

    private void saveData() {
        AppConfigStorageItem item = this.fetchEditedValues();
        String name = item.getString("name");
        item.removeSetting("name");
        if (name.length() > 0) {
            if (this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false)) {
                AppConfigStorage.instance.putCustomConfig(name, item);
            } else {
                String oldName = this.getIntent().getStringExtra(ARG_CONFIG_NAME);
                boolean wasSelected = oldName.equals(AppConfigStorage.instance.getSelectedConfigName());
                if (AppConfigStorage.instance.isCustomConfig(oldName) || AppConfigStorage.instance.isConfigOverride(oldName)) {
                    AppConfigStorage.instance.removeConfig(oldName);
                }
                AppConfigStorage.instance.putCustomConfig(name, item);
                if (wasSelected) {
                    AppConfigStorage.instance.selectConfig((Context)this, name);
                }
            }
            AppConfigStorage.instance.synchronizeCustomConfigWithPreferences((Context)this, name);
            this.setResult(-1);
            this.finish();
        }
    }
}

