/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.crescentflare.appconfig.helper.AppConfigViewHelper;

public class AppConfigEditableCell
extends FrameLayout {
    private TextView labelView;
    private AppCompatEditText editableView;
    private boolean isNumberLimit = false;

    public AppConfigEditableCell(Context context) {
        super(context);
        this.init(context, null);
    }

    public AppConfigEditableCell(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AppConfigEditableCell(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AppConfigEditableCell(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LinearLayout container = new LinearLayout(context);
        container.setOrientation(1);
        container.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        container.setPadding(this.dp(10), this.dp(12), this.dp(10), this.dp(12));
        this.addView((View)container);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.labelView = new TextView(context);
        container.addView((View)this.labelView);
        this.labelView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.labelView.setPadding(this.dp(4), 0, this.dp(4), 0);
        layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.editableView = new AppCompatEditText(context);
        container.addView((View)this.editableView);
        this.editableView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setDescription(String text) {
        this.labelView.setText((CharSequence)text);
    }

    public void setValue(String value) {
        this.editableView.setText((CharSequence)value);
    }

    public String getValue() {
        return this.editableView.getText().toString();
    }

    public void addTextChangedListener(TextWatcher textWatcher) {
        this.editableView.addTextChangedListener(textWatcher);
    }

    public void setNumberLimit(boolean numbersOnly) {
        if (numbersOnly) {
            this.editableView.setInputType(2);
            this.editableView.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)true, (boolean)false));
        } else {
            AppCompatEditText defaults = new AppCompatEditText(this.getContext());
            this.editableView.setInputType(defaults.getInputType());
            this.editableView.setKeyListener(defaults.getKeyListener());
        }
        this.isNumberLimit = numbersOnly;
    }

    public boolean isNumberLimit() {
        return this.isNumberLimit;
    }

    private int dp(int dp) {
        return AppConfigViewHelper.dp(dp);
    }
}

