/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.adapter;

public class AppConfigAdapterEntry {
    private Type type = Type.Configuration;
    private Section section = Section.Unknown;
    private String name = "";
    private String label = "";

    public AppConfigAdapterEntry(Type type, Section section, String name, String label) {
        this.type = type;
        this.section = section;
        this.name = name;
        this.label = label;
    }

    public static AppConfigAdapterEntry entryForConfiguration(Section section, String configurationName, boolean edited) {
        return new AppConfigAdapterEntry(Type.Configuration, section, configurationName, configurationName + (edited ? " *" : ""));
    }

    public static AppConfigAdapterEntry entryForConfiguration(Section section, String configurationName, String customLabel, boolean edited) {
        return new AppConfigAdapterEntry(Type.Configuration, section, configurationName, customLabel + (edited ? " *" : ""));
    }

    public static AppConfigAdapterEntry entryForBuildInfo(String key, String value) {
        return new AppConfigAdapterEntry(Type.BuildInfo, Section.Unknown, "", key + ": " + value);
    }

    public static AppConfigAdapterEntry entryForHeader(String headerName) {
        return new AppConfigAdapterEntry(Type.Header, Section.Unknown, "", headerName);
    }

    public static AppConfigAdapterEntry entryForFooter() {
        return new AppConfigAdapterEntry(Type.Footer, Section.Unknown, "", "");
    }

    public Type getType() {
        return this.type;
    }

    public Section getSection() {
        return this.section;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public static enum Section {
        Unknown,
        LastSelected,
        Predefined,
        Custom,
        Add;

    }

    public static enum Type {
        Configuration,
        BuildInfo,
        Header,
        Footer;

    }
}

