/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.crescentflare.appconfig.activity.AppConfigStringChoiceActivity;
import com.crescentflare.appconfig.activity.EditAppConfigActivity;
import com.crescentflare.appconfig.adapter.AppConfigAdapter;
import com.crescentflare.appconfig.adapter.AppConfigAdapterEntry;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import com.crescentflare.appconfig.manager.AppConfigStorage;
import java.util.ArrayList;

public class ManageAppConfigActivity
extends AppCompatActivity
implements AppConfigStorage.ChangedConfigListener {
    private static final int RESULT_CODE_CUSTOM_COPY_FROM = 1000;
    private static final int RESULT_CODE_EDIT_CONFIG = 1001;
    private LinearLayout layout = null;
    private ListView listView = null;
    private LinearLayout spinnerView = null;
    private AppConfigAdapter adapter = null;
    private int buildNr = -1;

    public static Intent newInstance(Context context) {
        return new Intent(context, ManageAppConfigActivity.class);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!AppConfigStorage.instance.isInitialized()) {
            this.finish();
            return;
        }
        try {
            PackageInfo info;
            PackageManager manager = this.getPackageManager();
            if (manager != null && (info = manager.getPackageInfo(this.getPackageName(), 0)) != null) {
                this.buildNr = info.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.layout = this.createContentView();
        this.setTitle(AppConfigResourceHelper.getString((Context)this, "app_config_title_list"));
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeButtonEnabled(true);
        }
        this.setContentView((View)this.layout);
        AppConfigStorage.instance.loadFromSource((Context)this, new Runnable(){

            @Override
            public void run() {
                ManageAppConfigActivity.this.populateContent();
            }
        });
    }

    public static void startWithResult(Activity fromActivity, int resultCode) {
        fromActivity.startActivityForResult(ManageAppConfigActivity.newInstance((Context)fromActivity), resultCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1000 && resultCode == -1) {
            String resultString = data.getStringExtra("ARG_INTENT_RESULT_SELECTED_STRING");
            if (resultString.length() > 0) {
                EditAppConfigActivity.startWithResult((Activity)this, resultString, true, 1001);
            }
        } else if (requestCode == 1001 && resultCode == -1) {
            this.populateContent();
        }
    }

    protected void onPause() {
        super.onPause();
        AppConfigStorage.instance.removeChangedConfigListener(this);
    }

    protected void onResume() {
        super.onResume();
        this.populateContent();
        AppConfigStorage.instance.addChangedConfigListener(this);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onChangedConfig() {
        this.populateContent();
    }

    private int dip(int pixels) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)pixels);
    }

    private LinearLayout createContentView() {
        this.layout = new LinearLayout((Context)this);
        this.layout.setOrientation(1);
        if (this.getSupportActionBar() == null) {
            Toolbar bar = new Toolbar((Context)this);
            this.layout.addView((View)bar, 0);
            this.setSupportActionBar(bar);
        }
        FrameLayout container = new FrameLayout((Context)this);
        this.layout.addView((View)container);
        this.listView = new ListView((Context)this);
        this.adapter = new AppConfigAdapter((Context)this);
        this.listView.setId(AppConfigResourceHelper.getIdentifier((Context)this, "app_config_activity_manage_list"));
        this.listView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "api_config_background"));
        this.listView.setDivider(null);
        this.listView.setDividerHeight(0);
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.listView.setVisibility(8);
        container.addView((View)this.listView);
        this.spinnerView = new LinearLayout((Context)this);
        this.spinnerView.setBackgroundColor(-1);
        this.spinnerView.setGravity(17);
        this.spinnerView.setOrientation(1);
        this.spinnerView.setPadding(this.dip(8), this.dip(8), this.dip(8), this.dip(8));
        container.addView((View)this.spinnerView);
        ProgressBar iconView = new ProgressBar((Context)this);
        this.spinnerView.addView((View)iconView);
        TextView progressTextView = new TextView((Context)this);
        LinearLayout.LayoutParams textLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        textLayoutParams.setMargins(0, this.dip(8), 0, 0);
        progressTextView.setLayoutParams((ViewGroup.LayoutParams)textLayoutParams);
        progressTextView.setGravity(1);
        progressTextView.setText((CharSequence)AppConfigResourceHelper.getString((Context)this, "app_config_loading"));
        this.spinnerView.addView((View)progressTextView);
        if (this.buildNr > 0) {
            TextView progressBuildView = new TextView((Context)this);
            LinearLayout.LayoutParams buildLayoutParams = new LinearLayout.LayoutParams(-1, -2);
            buildLayoutParams.setMargins(0, this.dip(2), 0, 0);
            progressBuildView.setLayoutParams((ViewGroup.LayoutParams)buildLayoutParams);
            progressBuildView.setGravity(1);
            progressBuildView.setText((CharSequence)("(" + AppConfigResourceHelper.getString((Context)this, "app_config_field_build").toLowerCase() + ": " + this.buildNr + ")"));
            this.spinnerView.addView((View)progressBuildView);
        }
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                AppConfigAdapterEntry entry = (AppConfigAdapterEntry)parent.getItemAtPosition(position);
                if (entry.getType() == AppConfigAdapterEntry.Type.Configuration) {
                    if (entry.getSection() == AppConfigAdapterEntry.Section.Add) {
                        ArrayList<String> configs = AppConfigStorage.instance.configList();
                        AppConfigStringChoiceActivity.startWithResult((Activity)ManageAppConfigActivity.this, AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_title_edit_new"), AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_header_choose_custom_copy"), configs, 1000);
                    } else {
                        AppConfigStorage.instance.selectConfig((Context)ManageAppConfigActivity.this, entry.getName());
                        ManageAppConfigActivity.this.setResult(-1);
                        ManageAppConfigActivity.this.finish();
                    }
                }
            }
        });
        this.listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                AppConfigAdapterEntry entry = (AppConfigAdapterEntry)parent.getItemAtPosition(position);
                if (entry.getType() == AppConfigAdapterEntry.Type.Configuration) {
                    if (entry.getSection() == AppConfigAdapterEntry.Section.Add) {
                        ArrayList<String> configs = AppConfigStorage.instance.configList();
                        AppConfigStringChoiceActivity.startWithResult((Activity)ManageAppConfigActivity.this, AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_title_choose_custom_copy"), AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_header_choose_custom_copy"), configs, 1000);
                    } else {
                        EditAppConfigActivity.startWithResult((Activity)ManageAppConfigActivity.this, entry.getName(), false, 1001);
                    }
                    return true;
                }
                return false;
            }
        });
        return this.layout;
    }

    private void populateContent() {
        this.spinnerView.setVisibility(AppConfigStorage.instance.isLoaded() ? 8 : 0);
        this.listView.setVisibility(AppConfigStorage.instance.isLoaded() ? 0 : 8);
        if (!AppConfigStorage.instance.isLoaded()) {
            return;
        }
        ArrayList<AppConfigAdapterEntry> entries = new ArrayList<AppConfigAdapterEntry>();
        entries.add(AppConfigAdapterEntry.entryForHeader(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_last_selection")));
        if (AppConfigStorage.instance.getSelectedConfig() != null) {
            String configName = AppConfigStorage.instance.getSelectedConfigName();
            entries.add(AppConfigAdapterEntry.entryForConfiguration(AppConfigAdapterEntry.Section.LastSelected, configName, configName, AppConfigStorage.instance.isConfigOverride(configName)));
        } else {
            entries.add(AppConfigAdapterEntry.entryForConfiguration(AppConfigAdapterEntry.Section.LastSelected, "", AppConfigResourceHelper.getString((Context)this, "app_config_item_none"), false));
        }
        ArrayList<String> configs = AppConfigStorage.instance.configList();
        if (configs.size() > 0) {
            entries.add(AppConfigAdapterEntry.entryForHeader(AppConfigResourceHelper.getString((Context)this, "app_config_header_list")));
            for (String configName : configs) {
                entries.add(AppConfigAdapterEntry.entryForConfiguration(AppConfigAdapterEntry.Section.Predefined, configName, AppConfigStorage.instance.isConfigOverride(configName)));
            }
        }
        ArrayList<String> customConfigs = AppConfigStorage.instance.customConfigList();
        entries.add(AppConfigAdapterEntry.entryForHeader(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_custom")));
        for (String configName : customConfigs) {
            if (!AppConfigStorage.instance.isCustomConfig(configName)) continue;
            entries.add(AppConfigAdapterEntry.entryForConfiguration(AppConfigAdapterEntry.Section.Custom, configName, false));
        }
        entries.add(AppConfigAdapterEntry.entryForConfiguration(AppConfigAdapterEntry.Section.Add, "", AppConfigResourceHelper.getString((Context)this, "app_config_action_add"), false));
        entries.add(AppConfigAdapterEntry.entryForHeader(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_build_info")));
        entries.add(AppConfigAdapterEntry.entryForBuildInfo(AppConfigResourceHelper.getString((Context)this, "app_config_field_build"), "" + this.buildNr));
        entries.add(AppConfigAdapterEntry.entryForBuildInfo(AppConfigResourceHelper.getString((Context)this, "app_config_field_api_level"), "" + Build.VERSION.SDK_INT));
        entries.add(AppConfigAdapterEntry.entryForFooter());
        this.adapter.setEntries(entries);
    }
}

