/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.adapter;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.crescentflare.appconfig.adapter.AppConfigAdapterEntry;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import java.util.ArrayList;

public class AppConfigAdapter
extends BaseAdapter
implements ListAdapter {
    private Context context;
    private ArrayList<AppConfigAdapterEntry> entries = new ArrayList();

    public AppConfigAdapter(Context context) {
        this.context = context;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int i) {
        return this.entries.get(i).getType() == AppConfigAdapterEntry.Type.Configuration && (this.entries.get(i).getName().length() > 0 || this.entries.get(i).getSection() == AppConfigAdapterEntry.Section.Add);
    }

    public int getCount() {
        return this.entries.size();
    }

    public Object getItem(int i) {
        return this.entries.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public boolean hasStableIds() {
        return false;
    }

    public int getItemViewType(int position) {
        int index = 0;
        for (AppConfigAdapterEntry.Type type : AppConfigAdapterEntry.Type.values()) {
            if (type == this.entries.get(position).getType()) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public int getViewTypeCount() {
        return AppConfigAdapterEntry.Type.values().length;
    }

    private int dip(int pixels) {
        return (int)(this.context.getResources().getDisplayMetrics().density * (float)pixels);
    }

    private Drawable generateSelectionBackgroundDrawable() {
        StateListDrawable drawable = null;
        if (Build.VERSION.SDK_INT >= 21) {
            int[][] states = new int[][]{{16842908}, {16842919}, {16842910}, {-16842910}};
            int[] colors = new int[]{AppConfigResourceHelper.getColor(this.context, "app_config_background"), AppConfigResourceHelper.getColor(this.context, "app_config_background"), -1, -1};
            RippleDrawable rippleDrawable = new RippleDrawable(new ColorStateList((int[][])states, colors), null, null);
            drawable = rippleDrawable;
        } else {
            StateListDrawable stateDrawable = new StateListDrawable();
            stateDrawable.addState(new int[]{16842908}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor(this.context, "app_config_background")));
            stateDrawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor(this.context, "app_config_background")));
            stateDrawable.addState(new int[]{16842910}, (Drawable)new ColorDrawable(-1));
            stateDrawable.addState(new int[]{-16842910}, (Drawable)new ColorDrawable(-1));
            drawable = stateDrawable;
        }
        return drawable;
    }

    private View generateSectionDivider(boolean includeBottomDivider) {
        LinearLayout dividerLayout = new LinearLayout(this.context);
        dividerLayout.setOrientation(1);
        View topLineView = new View(this.context);
        topLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        topLineView.setBackgroundColor(AppConfigResourceHelper.getColor(this.context, "app_config_section_divider_line"));
        dividerLayout.addView(topLineView);
        View gradientView = new View(this.context);
        int[] colors = new int[]{AppConfigResourceHelper.getColor(this.context, "app_config_section_gradient_start"), AppConfigResourceHelper.getColor(this.context, "app_config_section_gradient_end"), AppConfigResourceHelper.getColor(this.context, "app_config_background")};
        GradientDrawable drawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
        gradientView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dip(8)));
        if (Build.VERSION.SDK_INT < 16) {
            gradientView.setBackgroundDrawable((Drawable)drawable);
        } else {
            gradientView.setBackground((Drawable)drawable);
        }
        dividerLayout.addView(gradientView);
        if (includeBottomDivider) {
            View bottomLineView = new View(this.context);
            bottomLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            bottomLineView.setBackgroundColor(AppConfigResourceHelper.getColor(this.context, "app_config_section_divider_line"));
            dividerLayout.addView(bottomLineView);
        }
        return dividerLayout;
    }

    private View generateViewForType(AppConfigAdapterEntry.Type type) {
        ViewHolder viewHolder = new ViewHolder();
        LinearLayout createdView = null;
        switch (type) {
            case Configuration: {
                createdView = new LinearLayout(this.context);
                createdView.setOrientation(1);
                createdView.setBackgroundColor(-1);
                viewHolder.labelView = new TextView(this.context);
                createdView.addView((View)viewHolder.labelView);
                viewHolder.dividerView = new View(this.context);
                createdView.addView(viewHolder.dividerView);
                viewHolder.labelView.setGravity(16);
                viewHolder.labelView.setMinimumHeight(this.dip(60));
                viewHolder.labelView.setPadding(this.dip(12), this.dip(12), this.dip(12), this.dip(12));
                viewHolder.labelView.setTextSize(18.0f);
                if (Build.VERSION.SDK_INT < 16) {
                    viewHolder.labelView.setBackgroundDrawable(this.generateSelectionBackgroundDrawable());
                } else {
                    viewHolder.labelView.setBackground(this.generateSelectionBackgroundDrawable());
                }
                viewHolder.dividerView.setBackgroundColor(AppConfigResourceHelper.getColor(this.context, "app_config_list_divider_line"));
                viewHolder.dividerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
                ((LinearLayout.LayoutParams)viewHolder.dividerView.getLayoutParams()).setMargins(this.dip(12), 0, 0, 0);
                break;
            }
            case BuildInfo: {
                createdView = new LinearLayout(this.context);
                createdView.setOrientation(1);
                createdView.setBackgroundColor(-1);
                viewHolder.labelView = new TextView(this.context);
                createdView.addView((View)viewHolder.labelView);
                viewHolder.dividerView = new View(this.context);
                createdView.addView(viewHolder.dividerView);
                viewHolder.labelView.setPadding(this.dip(12), this.dip(12), this.dip(12), this.dip(12));
                viewHolder.dividerView.setBackgroundColor(AppConfigResourceHelper.getColor(this.context, "app_config_list_divider_line"));
                viewHolder.dividerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
                ((LinearLayout.LayoutParams)viewHolder.dividerView.getLayoutParams()).setMargins(this.dip(12), 0, 0, 0);
                break;
            }
            case Header: {
                createdView = new LinearLayout(this.context);
                createdView.setOrientation(1);
                createdView.setBackgroundColor(-1);
                viewHolder.dividerView = this.generateSectionDivider(true);
                createdView.addView(viewHolder.dividerView);
                viewHolder.labelView = new TextView(this.context);
                createdView.addView((View)viewHolder.labelView);
                viewHolder.labelView.setPadding(this.dip(12), this.dip(12), this.dip(12), this.dip(12));
                viewHolder.labelView.setTypeface(Typeface.DEFAULT_BOLD);
                viewHolder.labelView.setTextColor(AppConfigResourceHelper.getAccentColor(this.context));
                break;
            }
            case Footer: {
                createdView = new LinearLayout(this.context);
                createdView.setOrientation(1);
                createdView.setBackgroundColor(-1);
                viewHolder.dividerView = this.generateSectionDivider(false);
                createdView.addView(viewHolder.dividerView);
                break;
            }
            default: {
                return null;
            }
        }
        createdView.setTag((Object)viewHolder);
        return createdView;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        AppConfigAdapterEntry entry = (AppConfigAdapterEntry)this.getItem(i);
        if (view == null) {
            view = this.generateViewForType(entry.getType());
        }
        if (view != null) {
            ViewHolder viewHolder = (ViewHolder)view.getTag();
            if (viewHolder.labelView != null) {
                viewHolder.labelView.setText((CharSequence)entry.getLabel());
            }
            if (viewHolder.dividerView != null) {
                if (entry.getType() == AppConfigAdapterEntry.Type.Header) {
                    AppConfigAdapterEntry prevEntry = null;
                    if (i > 0) {
                        prevEntry = (AppConfigAdapterEntry)this.getItem(i - 1);
                    }
                    viewHolder.dividerView.setVisibility(prevEntry == null ? 8 : 0);
                } else if (entry.getType() == AppConfigAdapterEntry.Type.Configuration || entry.getType() == AppConfigAdapterEntry.Type.BuildInfo) {
                    AppConfigAdapterEntry nextEntry = null;
                    if (i < this.entries.size() - 1) {
                        nextEntry = (AppConfigAdapterEntry)this.getItem(i + 1);
                    }
                    viewHolder.dividerView.setVisibility(nextEntry != null && nextEntry.getType() == entry.getType() ? 0 : 8);
                }
            }
        }
        return view;
    }

    public void setEntries(ArrayList<AppConfigAdapterEntry> entries) {
        this.entries = entries;
        this.notifyDataSetChanged();
    }

    public static class ViewHolder {
        public TextView labelView = null;
        public View dividerView = null;
    }
}

