/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.crescentflare.appconfig.adapter.AppConfigChoiceAdapter;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import java.util.ArrayList;

public class AppConfigStringChoiceActivity
extends AppCompatActivity {
    public static final String ARG_INTENT_RESULT_SELECTED_INDEX = "ARG_INTENT_RESULT_SELECTED_INDEX";
    public static final String ARG_INTENT_RESULT_SELECTED_STRING = "ARG_INTENT_RESULT_SELECTED_STRING";
    private static final String ARG_TITLE = "ARG_TITLE";
    private static final String ARG_SELECTION_TITLE = "ARG_SELECTION_TITLE";
    private static final String ARG_CHOICES = "ARG_CHOICES";
    private ListView listView = null;
    private AppConfigChoiceAdapter adapter = null;

    public static Intent newInstance(Context context, String title, String selectionTitle, ArrayList<String> options) {
        Intent intent = new Intent(context, AppConfigStringChoiceActivity.class);
        intent.putExtra(ARG_TITLE, title);
        intent.putExtra(ARG_SELECTION_TITLE, selectionTitle);
        intent.putExtra(ARG_CHOICES, options);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.listView = new ListView((Context)this);
        this.listView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_background"));
        this.listView.setDivider(null);
        this.listView.setDividerHeight(0);
        this.setTitle(this.getIntent().getStringExtra(ARG_TITLE));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.setContentView((View)this.listView);
        this.listView.setHeaderDividersEnabled(false);
        this.listView.setFooterDividersEnabled(false);
        this.listView.addHeaderView(this.generateHeader());
        this.listView.addFooterView(this.generateFooter());
        this.adapter = new AppConfigChoiceAdapter((Context)this);
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.adapter.setChoices(this.getIntent().getStringArrayListExtra(ARG_CHOICES));
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (parent.getItemAtPosition(position) != null) {
                    Intent intent = AppConfigStringChoiceActivity.this.getIntent();
                    intent.putExtra(AppConfigStringChoiceActivity.ARG_INTENT_RESULT_SELECTED_INDEX, position);
                    intent.putExtra(AppConfigStringChoiceActivity.ARG_INTENT_RESULT_SELECTED_STRING, (String)parent.getItemAtPosition(position));
                    AppConfigStringChoiceActivity.this.setResult(-1, intent);
                    AppConfigStringChoiceActivity.this.finish();
                }
            }
        });
    }

    public static void startWithResult(Activity fromActivity, String title, String selectionTitle, ArrayList<String> options, int resultCode) {
        fromActivity.startActivityForResult(AppConfigStringChoiceActivity.newInstance((Context)fromActivity, title, selectionTitle, options), resultCode);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private int dip(int pixels) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)pixels);
    }

    private View generateHeader() {
        LinearLayout createdView = new LinearLayout((Context)this);
        TextView labelView = new TextView((Context)this);
        createdView.setOrientation(1);
        createdView.setBackgroundColor(-1);
        createdView.addView((View)labelView);
        labelView.setPadding(this.dip(12), this.dip(12), this.dip(12), this.dip(12));
        labelView.setTypeface(Typeface.DEFAULT_BOLD);
        labelView.setTextColor(AppConfigResourceHelper.getAccentColor((Context)this));
        labelView.setText((CharSequence)this.getIntent().getStringExtra(ARG_SELECTION_TITLE));
        return createdView;
    }

    private View generateFooter() {
        LinearLayout dividerLayout = new LinearLayout((Context)this);
        dividerLayout.setOrientation(1);
        View topLineView = new View((Context)this);
        topLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        topLineView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_section_divider_line"));
        dividerLayout.addView(topLineView);
        View gradientView = new View((Context)this);
        int[] colors = new int[]{AppConfigResourceHelper.getColor((Context)this, "app_config_section_gradient_start"), AppConfigResourceHelper.getColor((Context)this, "app_config_section_gradient_end"), AppConfigResourceHelper.getColor((Context)this, "app_config_background")};
        GradientDrawable drawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
        gradientView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dip(8)));
        if (Build.VERSION.SDK_INT < 16) {
            gradientView.setBackgroundDrawable((Drawable)drawable);
        } else {
            gradientView.setBackground((Drawable)drawable);
        }
        dividerLayout.addView(gradientView);
        return dividerLayout;
    }
}

