/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.model;

import java.util.ArrayList;
import java.util.HashMap;

public class AppConfigStorageItem {
    private HashMap<String, Object> storedSettings = new HashMap();

    public boolean getBoolean(String setting) {
        Object settingObject = this.storedSettings.get(setting);
        if (settingObject != null) {
            if (settingObject instanceof Boolean) {
                return (Boolean)settingObject;
            }
            if (settingObject instanceof Long) {
                return (Long)settingObject > 0L;
            }
            if (settingObject instanceof String) {
                return ((String)settingObject).equalsIgnoreCase("true");
            }
        }
        return false;
    }

    public int getInt(String setting) {
        Object settingObject = this.storedSettings.get(setting);
        if (settingObject != null) {
            if (settingObject instanceof Boolean) {
                return (Boolean)settingObject != false ? 1 : 0;
            }
            if (settingObject instanceof Long) {
                return ((Long)settingObject).intValue();
            }
            if (settingObject instanceof String) {
                try {
                    return Integer.valueOf((String)settingObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public long getLong(String setting) {
        Object settingObject = this.storedSettings.get(setting);
        if (settingObject != null) {
            if (settingObject instanceof Boolean) {
                return (Boolean)settingObject != false ? 1L : 0L;
            }
            if (settingObject instanceof Long) {
                return (Long)settingObject;
            }
            if (settingObject instanceof String) {
                try {
                    return Long.valueOf((String)settingObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    public String getString(String setting) {
        Object settingObject = this.storedSettings.get(setting);
        if (settingObject != null) {
            if (settingObject instanceof Boolean) {
                return (Boolean)settingObject != false ? "true" : "false";
            }
            if (settingObject instanceof Long) {
                return "" + (Long)settingObject;
            }
            if (settingObject instanceof String) {
                return (String)settingObject;
            }
        }
        return null;
    }

    public String getStringNotNull(String setting) {
        String result = this.getString(setting);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public Object get(String setting) {
        return this.storedSettings.get(setting);
    }

    public ArrayList<String> valueList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.storedSettings.keySet()) {
            list.add(key);
        }
        return list;
    }

    public void putBoolean(String setting, boolean value) {
        this.removeSetting(setting);
        this.storedSettings.put(setting, value);
    }

    public void putInt(String setting, int value) {
        this.putLong(setting, value);
    }

    public void putLong(String setting, long value) {
        this.removeSetting(setting);
        this.storedSettings.put(setting, value);
    }

    public void putString(String setting, String value) {
        this.removeSetting(setting);
        this.storedSettings.put(setting, value);
    }

    public void put(String setting, Object value) {
        if (value instanceof Boolean) {
            this.putBoolean(setting, (Boolean)value);
        } else if (value instanceof Integer) {
            this.putInt(setting, (Integer)value);
        } else if (value instanceof Long) {
            this.putLong(setting, (Long)value);
        } else if (value instanceof String) {
            this.putString(setting, (String)value);
        }
    }

    public boolean removeSetting(String setting) {
        if (this.storedSettings.containsKey(setting)) {
            this.storedSettings.remove(setting);
            return true;
        }
        return false;
    }

    public void copyValues(AppConfigStorageItem item) {
        if (item != null) {
            ArrayList<String> valueList = item.valueList();
            for (String value : valueList) {
                Object setting = item.get(value);
                if (setting instanceof Boolean) {
                    this.putBoolean(value, item.getBoolean(value));
                    continue;
                }
                if (setting instanceof Integer) {
                    this.putInt(value, 0 + item.getInt(value));
                    continue;
                }
                if (setting instanceof Long) {
                    this.putLong(value, 0L + item.getLong(value));
                    continue;
                }
                if (!(setting instanceof String)) continue;
                this.putString(value, "" + item.getString(value));
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof AppConfigStorageItem) {
            if (o == this) {
                return true;
            }
            AppConfigStorageItem checkItem = (AppConfigStorageItem)o;
            for (String key : this.storedSettings.keySet()) {
                if (checkItem.storedSettings.containsKey(key)) continue;
                return false;
            }
            for (String key : checkItem.storedSettings.keySet()) {
                if (this.storedSettings.containsKey(key)) continue;
                return false;
            }
            for (String key : this.storedSettings.keySet()) {
                Object value2;
                Object value1 = this.storedSettings.get(key);
                if (value1.equals(value2 = checkItem.storedSettings.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

