/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.helper;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.TypedValue;

public class AppConfigResourceHelper {
    public static int getAccentColor(Context context) {
        int identifier = context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        if (identifier == 0 && Build.VERSION.SDK_INT >= 21) {
            identifier = 16843829;
        }
        if (identifier > 0) {
            TypedValue typedValue = new TypedValue();
            TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{identifier});
            if (a != null) {
                int color = a.getColor(0, 0);
                a.recycle();
                return color;
            }
        }
        return -16777216;
    }

    public static int getColor(Context context, String name) {
        int identifier = context.getResources().getIdentifier(name, "color", context.getPackageName());
        if (identifier > 0) {
            return context.getResources().getColor(identifier);
        }
        return 0;
    }

    public static String getString(Context context, String name) {
        int identifier = context.getResources().getIdentifier(name, "string", context.getPackageName());
        if (identifier > 0) {
            return context.getResources().getString(identifier);
        }
        return "";
    }

    public static int getIdentifier(Context context, String name) {
        return context.getResources().getIdentifier(name, "id", context.getPackageName());
    }
}

