/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.adapter;

public class AppConfigAdapterEntry {
    private Type type = Type.Configuration;
    private String name = "";
    private String label = "";

    public AppConfigAdapterEntry(Type type, String name, String label) {
        this.type = type;
        this.name = name;
        this.label = label;
    }

    public static AppConfigAdapterEntry entryForConfiguration(String configurationName, boolean edited) {
        return new AppConfigAdapterEntry(Type.Configuration, configurationName, configurationName + (edited ? " *" : ""));
    }

    public static AppConfigAdapterEntry entryForConfiguration(String configurationName, String customLabel, boolean edited) {
        return new AppConfigAdapterEntry(Type.Configuration, configurationName, customLabel + (edited ? " *" : ""));
    }

    public static AppConfigAdapterEntry entryForBuildInfo(String key, String value) {
        return new AppConfigAdapterEntry(Type.BuildInfo, "", key + ": " + value);
    }

    public static AppConfigAdapterEntry entryForHeader(String headerName) {
        return new AppConfigAdapterEntry(Type.Header, "", headerName);
    }

    public static AppConfigAdapterEntry entryForFooter() {
        return new AppConfigAdapterEntry(Type.Footer, "", "");
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public static enum Type {
        Configuration,
        BuildInfo,
        Header,
        Footer;

    }
}

