/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import com.crescentflare.appconfig.manager.AppConfigBaseManager;
import com.crescentflare.appconfig.model.AppConfigStorageItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppConfigStorage {
    private static final String PREFERENCE_FILE_NAME = "custom.app.config";
    private static final String SELECTED_PREFIX = "selected.";
    private static final String CUSTOM_PREFIX = "custom.";
    public static AppConfigStorage instance = new AppConfigStorage();
    private AppConfigBaseManager configManager = null;
    private LinkedHashMap<String, AppConfigStorageItem> storedConfigs = new LinkedHashMap();
    private LinkedHashMap<String, AppConfigStorageItem> customConfigs = new LinkedHashMap();
    private ArrayList<ChangedConfigListener> changedConfigListeners = new ArrayList();
    private String loadFromAssetFile = null;
    private String selectedItem = "";
    private boolean customConfigLoaded = false;
    private boolean initialized = false;

    private AppConfigStorage() {
    }

    public void init(Context context) {
        this.init(context, null);
    }

    public void init(Context context, AppConfigBaseManager manager) {
        this.configManager = manager;
        this.loadSelectedItemFromPreferences(context);
        if (this.configManager != null) {
            this.configManager.applyCurrentConfig(this.selectedItem, this.getSelectedConfigNotNull());
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public AppConfigBaseManager getConfigManager() {
        return this.configManager;
    }

    public AppConfigStorageItem getConfig(String config) {
        if (this.customConfigs.containsKey(config)) {
            return this.customConfigs.get(config);
        }
        if (this.storedConfigs.containsKey(config)) {
            return this.storedConfigs.get(config);
        }
        return null;
    }

    public AppConfigStorageItem getConfigNotNull(String config) {
        AppConfigStorageItem item = this.getConfig(config);
        if (item == null) {
            item = new AppConfigStorageItem();
        }
        return item;
    }

    public AppConfigStorageItem getSelectedConfig() {
        return this.getConfig(this.selectedItem);
    }

    public AppConfigStorageItem getSelectedConfigNotNull() {
        return this.getConfigNotNull(this.selectedItem);
    }

    public String getSelectedConfigName() {
        return this.selectedItem;
    }

    public ArrayList<String> configList() {
        return this.nameListOfConfigMap(this.storedConfigs);
    }

    public ArrayList<String> customConfigList() {
        return this.nameListOfConfigMap(this.customConfigs);
    }

    private ArrayList<String> nameListOfConfigMap(LinkedHashMap<String, AppConfigStorageItem> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            list.add(key);
        }
        return list;
    }

    public void putConfig(String config, AppConfigStorageItem item) {
        this.removeConfig(config);
        if (item != null) {
            this.storedConfigs.put(config, item);
        }
    }

    public void putCustomConfig(String config, AppConfigStorageItem item) {
        if (this.customConfigs.containsKey(config)) {
            this.removeConfig(config);
        }
        if (!(item == null || this.storedConfigs.containsKey(config) && this.storedConfigs.get(config).equals(item))) {
            this.customConfigs.put(config, item);
        }
    }

    public boolean removeConfig(String config) {
        boolean removed = false;
        if (this.customConfigs.containsKey(config)) {
            this.customConfigs.remove(config);
            removed = true;
        } else if (this.storedConfigs.containsKey(config)) {
            this.storedConfigs.remove(config);
            removed = true;
        }
        if (removed && config.equals(this.selectedItem)) {
            this.selectedItem = "";
            if (this.configManager != null) {
                this.configManager.applyCurrentConfig(this.selectedItem, this.getSelectedConfigNotNull());
            }
            for (ChangedConfigListener listener : this.changedConfigListeners) {
                listener.onChangedConfig();
            }
        }
        return removed;
    }

    public void selectConfig(Context context, String config) {
        this.selectedItem = this.customConfigs.containsKey(config) ? config : (this.storedConfigs.containsKey(config) ? config : "");
        this.storeSelectedItemInPreferences(context);
        if (this.configManager != null) {
            this.configManager.applyCurrentConfig(this.selectedItem, this.getSelectedConfigNotNull());
        }
        for (ChangedConfigListener listener : this.changedConfigListeners) {
            listener.onChangedConfig();
        }
    }

    public boolean isCustomConfig(String config) {
        return this.customConfigs.containsKey(config) && !this.storedConfigs.containsKey(config);
    }

    public boolean isConfigOverride(String config) {
        return this.customConfigs.containsKey(config) && this.storedConfigs.containsKey(config);
    }

    public void clearAllToDefaults(Context context) {
        for (String config : this.customConfigs.keySet()) {
            this.removeCustomItemFromPreferences(context, config);
        }
        this.customConfigs.clear();
        this.selectedItem = "";
        this.storeSelectedItemInPreferences(context);
        if (this.configManager != null) {
            this.configManager.applyCurrentConfig(this.selectedItem, this.getSelectedConfigNotNull());
        }
        for (ChangedConfigListener listener : this.changedConfigListeners) {
            listener.onChangedConfig();
        }
    }

    public void manuallyChangeCurrentConfig(Context context, String key, String value) {
        this.getSelectedConfigNotNull().putString(key, value);
        this.storeSelectedItemInPreferences(context);
        if (this.configManager != null) {
            this.configManager.applyCurrentConfig(this.selectedItem, this.getSelectedConfigNotNull());
        }
        for (ChangedConfigListener listener : this.changedConfigListeners) {
            listener.onChangedConfig();
        }
    }

    public void setLoadingSourceAssetFile(String fileName) {
        this.loadFromAssetFile = fileName;
    }

    public void loadFromSource(final Context context, final Runnable runnable) {
        final Handler handler = new Handler();
        final String assetFile = this.loadFromAssetFile;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final LinkedHashMap loadedConfigs = AppConfigStorage.this.loadFromSourceInternal(context, assetFile);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (loadedConfigs != null) {
                            AppConfigStorage.this.storedConfigs = loadedConfigs;
                            AppConfigStorage.this.loadFromAssetFile = null;
                        }
                        if (!AppConfigStorage.this.customConfigLoaded) {
                            AppConfigStorage.this.loadCustomItemsFromPreferences(context);
                            AppConfigStorage.this.customConfigLoaded = true;
                        }
                        runnable.run();
                    }
                });
            }
        });
        thread.start();
    }

    public void loadFromSourceNotThreaded(Context context) {
        LinkedHashMap<String, AppConfigStorageItem> loadedConfigs = this.loadFromSourceInternal(context, this.loadFromAssetFile);
        if (loadedConfigs != null) {
            this.storedConfigs = this.loadFromSourceInternal(context, this.loadFromAssetFile);
            this.loadFromAssetFile = null;
            if (!this.customConfigLoaded) {
                this.loadCustomItemsFromPreferences(context);
                this.customConfigLoaded = true;
            }
        }
    }

    private LinkedHashMap<String, AppConfigStorageItem> loadFromSourceInternal(Context context, String assetFile) {
        ArrayList<String> values;
        if (assetFile == null || !assetFile.endsWith(".json")) {
            return null;
        }
        AppConfigStorageItem defaultItem = null;
        if (this.configManager != null && (values = this.configManager.getBaseModelInstance().valueList()).size() > 0) {
            defaultItem = new AppConfigStorageItem();
            for (String value : values) {
                if (value.equals("name")) continue;
                Object setting = this.configManager.getBaseModelInstance().getCurrentValue(value);
                if (setting instanceof Long) {
                    defaultItem.putLong(value, (Long)setting);
                    continue;
                }
                if (setting instanceof Integer) {
                    defaultItem.putInt(value, (Integer)setting);
                    continue;
                }
                if (setting instanceof Boolean) {
                    defaultItem.putBoolean(value, (Boolean)setting);
                    continue;
                }
                defaultItem.putString(value, setting.toString());
            }
        }
        LinkedHashMap<String, AppConfigStorageItem> loadedConfigs = new LinkedHashMap<String, AppConfigStorageItem>();
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetFile);
        }
        catch (IOException value) {
            // empty catch block
        }
        String result = "{}";
        if (inputStream != null) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line = null;
                String ls = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
            }
            catch (IOException reader) {
                // empty catch block
            }
            result = stringBuilder.toString();
        }
        try {
            JSONArray configArray = new JSONArray(result);
            for (int i = 0; i < configArray.length(); ++i) {
                this.addStorageItemFromJson(loadedConfigs, configArray.optJSONObject(i), defaultItem);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return loadedConfigs;
    }

    private void addStorageItemFromJson(HashMap<String, AppConfigStorageItem> loadedConfigs, JSONObject json, AppConfigStorageItem parent) {
        JSONArray subConfigs;
        AppConfigStorageItem addItem = new AppConfigStorageItem();
        Iterator iterator = json.keys();
        addItem.copyValues(parent);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equals("subConfigs") || key.equals("name") || json.isNull(key)) continue;
            addItem.put(key, json.opt(key));
        }
        if (json.has("name")) {
            loadedConfigs.put(json.optString("name"), addItem);
        }
        if ((subConfigs = json.optJSONArray("subConfigs")) != null) {
            for (int i = 0; i < subConfigs.length(); ++i) {
                this.addStorageItemFromJson(loadedConfigs, subConfigs.optJSONObject(i), addItem);
            }
        }
    }

    public void synchronizeCustomConfigWithPreferences(Context context, String config) {
        if (this.customConfigs.containsKey(config)) {
            this.storeCustomItemInPreferences(context, config);
        } else {
            this.removeCustomItemFromPreferences(context, config);
        }
    }

    private void loadSelectedItemFromPreferences(Context context) {
        String preferencesFileName = context.getPackageName() + "." + PREFERENCE_FILE_NAME;
        SharedPreferences preferences = context.getSharedPreferences(preferencesFileName, 0);
        Map objectMap = preferences.getAll();
        AppConfigStorageItem selectedItem = new AppConfigStorageItem();
        String configurationName = "";
        for (String key : objectMap.keySet()) {
            if (!key.startsWith(SELECTED_PREFIX)) continue;
            if ((key = key.substring(SELECTED_PREFIX.length())).equals("name")) {
                configurationName = (String)objectMap.get(SELECTED_PREFIX + key);
                continue;
            }
            selectedItem.put(key, objectMap.get(SELECTED_PREFIX + key));
        }
        if (configurationName.length() > 0) {
            this.putConfig(configurationName, selectedItem);
            this.selectedItem = configurationName;
        }
    }

    private void storeSelectedItemInPreferences(Context context) {
        String preferencesFileName = context.getPackageName() + "." + PREFERENCE_FILE_NAME;
        SharedPreferences preferences = context.getSharedPreferences(preferencesFileName, 0);
        Map objectMap = preferences.getAll();
        SharedPreferences.Editor editor = preferences.edit();
        for (String key : objectMap.keySet()) {
            if (!key.startsWith(SELECTED_PREFIX)) continue;
            editor.remove(key);
        }
        if (this.selectedItem.length() > 0) {
            AppConfigStorageItem item = this.getSelectedConfigNotNull();
            ArrayList<String> valueList = item.valueList();
            editor.putString("selected.name", this.selectedItem);
            for (String key : valueList) {
                Object itemValue = item.get(key);
                if (itemValue instanceof Boolean) {
                    editor.putBoolean(SELECTED_PREFIX + key, item.getBoolean(key));
                    continue;
                }
                if (itemValue instanceof Integer) {
                    editor.putInt(SELECTED_PREFIX + key, item.getInt(key));
                    continue;
                }
                if (itemValue instanceof Long) {
                    editor.putLong(SELECTED_PREFIX + key, item.getLong(key));
                    continue;
                }
                editor.putString(SELECTED_PREFIX + key, item.getStringNotNull(key));
            }
        }
        editor.apply();
    }

    private void loadCustomItemsFromPreferences(Context context) {
        LinkedHashMap<String, AppConfigStorageItem> loadedConfigs = new LinkedHashMap<String, AppConfigStorageItem>();
        String preferencesFileName = context.getPackageName() + "." + PREFERENCE_FILE_NAME;
        SharedPreferences preferences = context.getSharedPreferences(preferencesFileName, 0);
        Map objectMap = preferences.getAll();
        this.customConfigs.clear();
        for (String key : objectMap.keySet()) {
            String customKey;
            int dotPos;
            if (!key.startsWith(CUSTOM_PREFIX) || (dotPos = (customKey = key.substring(CUSTOM_PREFIX.length())).indexOf(46)) < 0) continue;
            String configName = customKey.substring(0, dotPos);
            String keyName = customKey.substring(dotPos + 1);
            if (!loadedConfigs.containsKey(configName)) {
                loadedConfigs.put(configName, new AppConfigStorageItem());
            }
            AppConfigStorageItem item = (AppConfigStorageItem)loadedConfigs.get(configName);
            Object addObject = objectMap.get(key);
            if (addObject instanceof Boolean) {
                item.putBoolean(keyName, (Boolean)objectMap.get(key));
                continue;
            }
            if (addObject instanceof Integer) {
                item.putInt(keyName, (Integer)objectMap.get(key));
                continue;
            }
            if (addObject instanceof Long) {
                item.putLong(keyName, (Long)objectMap.get(key));
                continue;
            }
            if (!(addObject instanceof String)) continue;
            item.putString(keyName, (String)objectMap.get(key));
        }
        this.customConfigs = loadedConfigs;
        if (this.selectedItem.length() > 0) {
            this.selectConfig(context, this.selectedItem);
        }
    }

    private void removeCustomItemFromPreferences(Context context, String config) {
        String preferencesFileName = context.getPackageName() + "." + PREFERENCE_FILE_NAME;
        SharedPreferences preferences = context.getSharedPreferences(preferencesFileName, 0);
        Map objectMap = preferences.getAll();
        SharedPreferences.Editor editor = preferences.edit();
        for (String key : objectMap.keySet()) {
            if (!key.startsWith(CUSTOM_PREFIX + config + ".")) continue;
            editor.remove(key);
        }
        editor.apply();
    }

    private void storeCustomItemInPreferences(Context context, String config) {
        if (this.customConfigs.containsKey(config)) {
            String preferencesFileName = context.getPackageName() + "." + PREFERENCE_FILE_NAME;
            SharedPreferences preferences = context.getSharedPreferences(preferencesFileName, 0);
            SharedPreferences.Editor editor = preferences.edit();
            this.removeCustomItemFromPreferences(context, config);
            AppConfigStorageItem item = this.customConfigs.get(config);
            ArrayList<String> valueList = item.valueList();
            for (String key : valueList) {
                Object itemValue = item.get(key);
                if (itemValue instanceof Boolean) {
                    editor.putBoolean(CUSTOM_PREFIX + config + "." + key, item.getBoolean(key));
                    continue;
                }
                if (itemValue instanceof Integer) {
                    editor.putInt(CUSTOM_PREFIX + config + "." + key, item.getInt(key));
                    continue;
                }
                if (itemValue instanceof Long) {
                    editor.putLong(CUSTOM_PREFIX + config + "." + key, item.getLong(key));
                    continue;
                }
                editor.putString(CUSTOM_PREFIX + config + "." + key, item.getStringNotNull(key));
            }
            editor.apply();
        }
    }

    public void addChangedConfigListener(ChangedConfigListener listener) {
        if (!this.changedConfigListeners.contains(listener)) {
            this.changedConfigListeners.add(listener);
        }
    }

    public void removeChangedConfigListener(ChangedConfigListener listener) {
        if (this.changedConfigListeners.contains(listener)) {
            this.changedConfigListeners.remove(listener);
        }
    }

    public static interface ChangedConfigListener {
        public void onChangedConfig();
    }
}

