/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.SwitchCompat;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import com.crescentflare.appconfig.activity.AppConfigStringChoiceActivity;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import com.crescentflare.appconfig.manager.AppConfigStorage;
import com.crescentflare.appconfig.model.AppConfigBaseModel;
import com.crescentflare.appconfig.model.AppConfigStorageItem;
import java.util.ArrayList;
import java.util.Iterator;

public class EditAppConfigActivity
extends AppCompatActivity {
    private static final String ARG_CONFIG_NAME = "ARG_CONFIG_NAME";
    private static final String ARG_CREATE_CUSTOM = "ARG_CREATE_CUSTOM";
    private static final int RESULT_CODE_SELECT_ENUM = 1004;
    private ArrayList<View> fieldViews = new ArrayList();
    private FrameLayout layout = null;
    private LinearLayout editingView = null;
    private LinearLayout spinnerView = null;

    public static Intent newInstance(Context context, String config, boolean createCustom) {
        Intent intent = new Intent(context, EditAppConfigActivity.class);
        intent.putExtra(ARG_CONFIG_NAME, config);
        intent.putExtra(ARG_CREATE_CUSTOM, createCustom);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.layout = this.createContentView();
        this.setTitle(AppConfigResourceHelper.getString((Context)this, this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false) ? "app_config_title_edit_new" : "app_config_title_edit"));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.setContentView((View)this.layout);
        AppConfigStorage.instance.loadFromSource((Context)this, new Runnable(){

            @Override
            public void run() {
                EditAppConfigActivity.this.populateContent();
            }
        });
    }

    public static void startWithResult(Activity fromActivity, String config, boolean createCustom, int resultCode) {
        fromActivity.startActivityForResult(EditAppConfigActivity.newInstance((Context)fromActivity, config, createCustom), resultCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        String resultString;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode >= 1004 && requestCode < 2004 && resultCode == -1 && (resultString = data.getStringExtra("ARG_INTENT_RESULT_SELECTED_STRING")).length() > 0) {
            ArrayList<Object> modelValues = new ArrayList();
            int index = requestCode - 1004;
            if (AppConfigStorage.instance.getConfigManager() != null) {
                modelValues = AppConfigStorage.instance.getConfigManager().getBaseModelInstance().valueList();
            }
            if (index < modelValues.size()) {
                TextView foundView = null;
                for (View view : this.fieldViews) {
                    if (!(view instanceof TextView) || !view.getTag().equals(modelValues.get(index))) continue;
                    foundView = (TextView)view;
                    break;
                }
                if (foundView != null) {
                    foundView.setText((CharSequence)((String)modelValues.get(index) + ": " + resultString));
                }
            }
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private int dip(int pixels) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)pixels);
    }

    private Drawable generateSelectionBackgroundDrawable() {
        StateListDrawable drawable = null;
        if (Build.VERSION.SDK_INT >= 21) {
            int[][] states = new int[][]{{16842908}, {16842919}, {16842910}, {-16842910}};
            int[] colors = new int[]{AppConfigResourceHelper.getColor((Context)this, "app_config_background"), AppConfigResourceHelper.getColor((Context)this, "app_config_background"), -1, -1};
            RippleDrawable rippleDrawable = new RippleDrawable(new ColorStateList((int[][])states, colors), null, null);
            drawable = rippleDrawable;
        } else {
            StateListDrawable stateDrawable = new StateListDrawable();
            stateDrawable.addState(new int[]{16842908}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor((Context)this, "app_config_background")));
            stateDrawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor((Context)this, "app_config_background")));
            stateDrawable.addState(new int[]{16842910}, (Drawable)new ColorDrawable(-1));
            stateDrawable.addState(new int[]{-16842910}, (Drawable)new ColorDrawable(-1));
            drawable = stateDrawable;
        }
        return drawable;
    }

    private View generateSectionDivider(boolean includeBottomDivider) {
        LinearLayout dividerLayout = new LinearLayout((Context)this);
        dividerLayout.setOrientation(1);
        View topLineView = new View((Context)this);
        topLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        topLineView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_section_divider_line"));
        dividerLayout.addView(topLineView);
        View gradientView = new View((Context)this);
        int[] colors = new int[]{AppConfigResourceHelper.getColor((Context)this, "app_config_section_gradient_start"), AppConfigResourceHelper.getColor((Context)this, "app_config_section_gradient_end"), AppConfigResourceHelper.getColor((Context)this, "app_config_background")};
        GradientDrawable drawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
        gradientView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dip(8)));
        if (Build.VERSION.SDK_INT < 16) {
            gradientView.setBackgroundDrawable((Drawable)drawable);
        } else {
            gradientView.setBackground((Drawable)drawable);
        }
        dividerLayout.addView(gradientView);
        if (includeBottomDivider) {
            View bottomLineView = new View((Context)this);
            bottomLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            bottomLineView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_section_divider_line"));
            dividerLayout.addView(bottomLineView);
        }
        return dividerLayout;
    }

    private LinearLayout generateHeaderView(String label) {
        LinearLayout createdView = new LinearLayout((Context)this);
        createdView.setOrientation(1);
        createdView.setBackgroundColor(-1);
        TextView labelView = new TextView((Context)this);
        createdView.addView((View)labelView);
        labelView.setPadding(this.dip(12), this.dip(12), this.dip(12), this.dip(12));
        labelView.setTypeface(Typeface.DEFAULT_BOLD);
        labelView.setTextColor(AppConfigResourceHelper.getAccentColor((Context)this));
        labelView.setText((CharSequence)label);
        return createdView;
    }

    private LinearLayout generateButtonView(String action, boolean addDivider) {
        return this.generateButtonView(null, action, addDivider, false);
    }

    private LinearLayout generateButtonView(String label, String setting, boolean addDivider, boolean addTopDivider) {
        LinearLayout createdView = new LinearLayout((Context)this);
        createdView.setOrientation(1);
        createdView.setBackgroundColor(-1);
        if (addTopDivider) {
            View topDividerView = null;
            topDividerView = new View((Context)this);
            createdView.addView(topDividerView);
            topDividerView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_list_divider_line"));
            topDividerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            ((LinearLayout.LayoutParams)topDividerView.getLayoutParams()).setMargins(this.dip(12), 0, 0, 0);
        }
        TextView labelView = new TextView((Context)this);
        createdView.addView((View)labelView);
        labelView.setGravity(16);
        labelView.setMinimumHeight(this.dip(60));
        labelView.setPadding(this.dip(12), this.dip(12), this.dip(12), this.dip(12));
        labelView.setTextSize(18.0f);
        labelView.setTag((Object)label);
        if (Build.VERSION.SDK_INT < 16) {
            labelView.setBackgroundDrawable(this.generateSelectionBackgroundDrawable());
        } else {
            labelView.setBackground(this.generateSelectionBackgroundDrawable());
        }
        labelView.setText((CharSequence)setting);
        if (addDivider) {
            View dividerView = new View((Context)this);
            createdView.addView(dividerView);
            dividerView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_list_divider_line"));
            dividerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            ((LinearLayout.LayoutParams)dividerView.getLayoutParams()).setMargins(this.dip(12), 0, 0, 0);
        }
        return createdView;
    }

    private LinearLayout generateEditTextView(String label, String setting, boolean limitNumbers, boolean addDivider) {
        LinearLayout createdView = new LinearLayout((Context)this);
        LinearLayout.LayoutParams editViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        createdView.setOrientation(1);
        createdView.setPadding(0, this.dip(10), 0, this.dip(10));
        TextView labelView = new TextView((Context)this);
        createdView.addView((View)labelView);
        AppCompatEditText editView = new AppCompatEditText((Context)this);
        createdView.addView((View)editView);
        labelView.setPadding(this.dip(12), 0, this.dip(12), 0);
        labelView.setText((CharSequence)label);
        editViewLayoutParams.setMargins(this.dip(8), this.dip(0), this.dip(8), 0);
        editView.setLayoutParams((ViewGroup.LayoutParams)editViewLayoutParams);
        editView.setText((CharSequence)setting);
        editView.setTag((Object)label);
        if (limitNumbers) {
            editView.setInputType(2);
            editView.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)true, (boolean)false));
        }
        if (addDivider) {
            // empty if block
        }
        return createdView;
    }

    private LinearLayout generateSwitchView(String label, boolean setting, boolean addDivider, boolean addTopDivider) {
        LinearLayout createdView = new LinearLayout((Context)this);
        LinearLayout.LayoutParams switchViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        createdView.setOrientation(1);
        if (addTopDivider) {
            View topDividerView = null;
            topDividerView = new View((Context)this);
            createdView.addView(topDividerView);
            topDividerView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_list_divider_line"));
            topDividerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            ((LinearLayout.LayoutParams)topDividerView.getLayoutParams()).setMargins(this.dip(12), 0, 0, 0);
        }
        SwitchCompat switchView = new SwitchCompat((Context)this);
        createdView.addView((View)switchView);
        switchView.setPadding(this.dip(12), this.dip(20), this.dip(12), this.dip(20));
        switchView.setLayoutParams((ViewGroup.LayoutParams)switchViewLayoutParams);
        switchView.setTextSize(18.0f);
        switchView.setText((CharSequence)label);
        switchView.setChecked(setting);
        switchView.setTag((Object)label);
        if (addDivider) {
            View dividerView = new View((Context)this);
            createdView.addView(dividerView);
            dividerView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_list_divider_line"));
            dividerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            ((LinearLayout.LayoutParams)dividerView.getLayoutParams()).setMargins(this.dip(12), 0, 0, 0);
        }
        return createdView;
    }

    private FrameLayout createContentView() {
        this.layout = new FrameLayout((Context)this);
        this.layout.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "app_config_background"));
        ScrollView scrollView = new ScrollView((Context)this);
        this.editingView = new LinearLayout((Context)this);
        this.editingView.setOrientation(1);
        this.editingView.setVisibility(8);
        scrollView.addView((View)this.editingView);
        this.layout.addView((View)scrollView);
        this.spinnerView = new LinearLayout((Context)this);
        this.spinnerView.setBackgroundColor(-1);
        this.spinnerView.setGravity(17);
        this.spinnerView.setOrientation(1);
        this.spinnerView.setPadding(this.dip(8), this.dip(8), this.dip(8), this.dip(8));
        this.layout.addView((View)this.spinnerView);
        ProgressBar iconView = new ProgressBar((Context)this);
        this.spinnerView.addView((View)iconView);
        TextView progressTextView = new TextView((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.setMargins(0, this.dip(12), 0, 0);
        progressTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressTextView.setGravity(1);
        progressTextView.setText((CharSequence)AppConfigResourceHelper.getString((Context)this, "app_config_loading"));
        this.spinnerView.addView((View)progressTextView);
        return this.layout;
    }

    private void populateContent() {
        this.spinnerView.setVisibility(8);
        this.editingView.setVisibility(0);
        this.editingView.removeAllViews();
        this.fieldViews.clear();
        LinearLayout fieldEditLayout = new LinearLayout((Context)this);
        fieldEditLayout.setOrientation(1);
        fieldEditLayout.setBackgroundColor(-1);
        fieldEditLayout.addView((View)this.generateHeaderView(this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false) ? AppConfigResourceHelper.getString((Context)this, "app_config_header_edit_new") : this.getIntent().getStringExtra(ARG_CONFIG_NAME)));
        this.editingView.addView((View)fieldEditLayout);
        this.editingView.addView(this.generateSectionDivider(true));
        LinearLayout buttonLayout = new LinearLayout((Context)this);
        buttonLayout.setOrientation(1);
        buttonLayout.setBackgroundColor(-1);
        buttonLayout.addView((View)this.generateHeaderView(AppConfigResourceHelper.getString((Context)this, "app_config_header_edit_actions")));
        this.editingView.addView((View)buttonLayout);
        this.editingView.addView(this.generateSectionDivider(false));
        AppConfigStorageItem config = AppConfigStorage.instance.getConfigNotNull(this.getIntent().getStringExtra(ARG_CONFIG_NAME));
        ArrayList<String> values = config.valueList();
        ArrayList<String> modelValues = null;
        if (AppConfigStorage.instance.getConfigManager() != null) {
            modelValues = AppConfigStorage.instance.getConfigManager().getBaseModelInstance().valueList();
        }
        if (AppConfigStorage.instance.isCustomConfig(this.getIntent().getStringExtra(ARG_CONFIG_NAME)) || this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false)) {
            String name = this.getIntent().getStringExtra(ARG_CONFIG_NAME);
            if (this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false)) {
                name = name + " " + AppConfigResourceHelper.getString((Context)this, "app_config_modifier_copy");
            }
            LinearLayout layoutView = this.generateEditTextView("name", name, false, values.size() > 0);
            fieldEditLayout.addView((View)layoutView);
            this.fieldViews.add(layoutView.findViewWithTag((Object)"name"));
        }
        if (modelValues != null) {
            AppConfigBaseModel baseModel = AppConfigStorage.instance.getConfigManager().getBaseModelInstance();
            Object saveResult = null;
            baseModel.applyCustomSettings(this.getIntent().getStringExtra(ARG_CONFIG_NAME), config);
            for (int i = 0; i < modelValues.size(); ++i) {
                final String value = modelValues.get(i);
                if (value.equals("name")) continue;
                LinearLayout layoutView = null;
                final Object result = baseModel.getCurrentValue(value);
                Object previousResult = saveResult;
                if (result == null) continue;
                if (result instanceof Boolean) {
                    layoutView = this.generateSwitchView(value, (Boolean)result, i < modelValues.size() - 1, previousResult != null && (previousResult instanceof String || previousResult instanceof Integer || previousResult instanceof Long));
                } else if (result.getClass().isEnum()) {
                    final int index = i;
                    layoutView = this.generateButtonView(value, value + ": " + result.toString(), i < modelValues.size() - 1, previousResult != null && (previousResult instanceof String || previousResult instanceof Integer || previousResult instanceof Long));
                    layoutView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            ?[] constants = result.getClass().getEnumConstants();
                            ArrayList<String> enumValues = new ArrayList<String>();
                            for (int i = 0; i < constants.length; ++i) {
                                enumValues.add(constants[i].toString());
                            }
                            if (enumValues.size() > 0) {
                                AppConfigStringChoiceActivity.startWithResult((Activity)EditAppConfigActivity.this, AppConfigResourceHelper.getString((Context)EditAppConfigActivity.this, "app_config_title_choose_enum_prefix") + " " + value, AppConfigResourceHelper.getString((Context)EditAppConfigActivity.this, "app_config_header_choose_enum"), enumValues, 1004 + index);
                            }
                        }
                    });
                } else if (result instanceof Integer || result instanceof Long) {
                    layoutView = this.generateEditTextView(value, "" + result, true, i < modelValues.size() - 1);
                } else if (result instanceof String) {
                    layoutView = this.generateEditTextView(value, (String)result, false, i < modelValues.size() - 1);
                }
                if (layoutView != null) {
                    fieldEditLayout.addView((View)layoutView);
                    this.fieldViews.add(layoutView.findViewWithTag((Object)value));
                }
                saveResult = result;
            }
        } else {
            boolean previousEditText = false;
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                LinearLayout layoutView = null;
                Object rawValue = config.get(value);
                if (rawValue instanceof Boolean) {
                    layoutView = this.generateSwitchView(value, config.getBoolean(value), i < values.size() - 1, previousEditText);
                } else {
                    layoutView = this.generateEditTextView(value, config.getStringNotNull(value), rawValue instanceof Integer || rawValue instanceof Long, i < values.size() - 1);
                    previousEditText = true;
                }
                fieldEditLayout.addView((View)layoutView);
                this.fieldViews.add(layoutView.findViewWithTag((Object)value));
            }
        }
        if (this.getIntent().getBooleanExtra(ARG_CREATE_CUSTOM, false)) {
            LinearLayout createButton = this.generateButtonView(AppConfigResourceHelper.getString((Context)this, "app_config_action_ok_edit_new"), true);
            buttonLayout.addView((View)createButton);
            createButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    View view;
                    AppConfigStorageItem item = new AppConfigStorageItem();
                    String name = "";
                    Iterator i$ = EditAppConfigActivity.this.fieldViews.iterator();
                    while (i$.hasNext() && (view = (View)i$.next()).getTag() != null) {
                        if (view.getTag().equals("name")) {
                            if (!(view instanceof AppCompatEditText)) continue;
                            name = ((AppCompatEditText)view).getText().toString();
                            continue;
                        }
                        if (view instanceof AppCompatEditText) {
                            if (((AppCompatEditText)view).getInputType() == 2) {
                                long number = 0L;
                                try {
                                    number = Long.parseLong(((AppCompatEditText)view).getText().toString());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                item.putLong((String)view.getTag(), number);
                                continue;
                            }
                            item.putString((String)view.getTag(), ((AppCompatEditText)view).getText().toString());
                            continue;
                        }
                        if (view instanceof SwitchCompat) {
                            item.putBoolean((String)view.getTag(), ((SwitchCompat)view).isChecked());
                            continue;
                        }
                        if (!(view instanceof TextView)) continue;
                        item.putString((String)view.getTag(), ((TextView)view).getText().toString());
                    }
                    if (name.length() > 0) {
                        AppConfigStorage.instance.putCustomConfig(name, item);
                        AppConfigStorage.instance.synchronizeCustomConfigWithPreferences((Context)EditAppConfigActivity.this, name);
                        EditAppConfigActivity.this.setResult(-1);
                        EditAppConfigActivity.this.finish();
                    }
                }
            });
        } else {
            LinearLayout saveButton = this.generateButtonView(AppConfigResourceHelper.getString((Context)this, "app_config_action_ok_edit"), true);
            buttonLayout.addView((View)saveButton);
            saveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    View view;
                    AppConfigStorageItem item = new AppConfigStorageItem();
                    String name = EditAppConfigActivity.this.getIntent().getStringExtra(EditAppConfigActivity.ARG_CONFIG_NAME);
                    Iterator i$ = EditAppConfigActivity.this.fieldViews.iterator();
                    while (i$.hasNext() && (view = (View)i$.next()).getTag() != null) {
                        if (view.getTag().equals("name")) {
                            if (!(view instanceof AppCompatEditText)) continue;
                            name = ((AppCompatEditText)view).getText().toString();
                            continue;
                        }
                        if (view instanceof AppCompatEditText) {
                            if (((AppCompatEditText)view).getInputType() == 2) {
                                long number = 0L;
                                try {
                                    number = Long.parseLong(((AppCompatEditText)view).getText().toString());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                item.putLong((String)view.getTag(), number);
                                continue;
                            }
                            item.putString((String)view.getTag(), ((AppCompatEditText)view).getText().toString());
                            continue;
                        }
                        if (view instanceof SwitchCompat) {
                            item.putBoolean((String)view.getTag(), ((SwitchCompat)view).isChecked());
                            continue;
                        }
                        if (!(view instanceof TextView)) continue;
                        item.putString((String)view.getTag(), ((TextView)view).getText().toString());
                    }
                    if (name.length() > 0) {
                        if (AppConfigStorage.instance.isCustomConfig(name) || AppConfigStorage.instance.isConfigOverride(name)) {
                            AppConfigStorage.instance.removeConfig(EditAppConfigActivity.this.getIntent().getStringExtra(EditAppConfigActivity.ARG_CONFIG_NAME));
                        }
                        AppConfigStorage.instance.putCustomConfig(name, item);
                        AppConfigStorage.instance.synchronizeCustomConfigWithPreferences((Context)EditAppConfigActivity.this, name);
                        EditAppConfigActivity.this.setResult(-1);
                        EditAppConfigActivity.this.finish();
                    }
                }
            });
            String buttonText = AppConfigResourceHelper.getString((Context)this, AppConfigStorage.instance.isCustomConfig(this.getIntent().getStringExtra(ARG_CONFIG_NAME)) ? "app_config_action_delete" : "app_config_action_restore");
            LinearLayout deleteButton = this.generateButtonView(buttonText, true);
            buttonLayout.addView((View)deleteButton);
            deleteButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String configName = EditAppConfigActivity.this.getIntent().getStringExtra(EditAppConfigActivity.ARG_CONFIG_NAME);
                    if (AppConfigStorage.instance.isCustomConfig(configName) || AppConfigStorage.instance.isConfigOverride(configName)) {
                        AppConfigStorage.instance.removeConfig(configName);
                        AppConfigStorage.instance.synchronizeCustomConfigWithPreferences((Context)EditAppConfigActivity.this, EditAppConfigActivity.this.getIntent().getStringExtra(EditAppConfigActivity.ARG_CONFIG_NAME));
                        EditAppConfigActivity.this.setResult(-1);
                    } else {
                        EditAppConfigActivity.this.setResult(0);
                    }
                    EditAppConfigActivity.this.finish();
                }
            });
        }
        LinearLayout cancelButton = this.generateButtonView(AppConfigResourceHelper.getString((Context)this, "app_config_action_cancel"), false);
        buttonLayout.addView((View)cancelButton);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditAppConfigActivity.this.onBackPressed();
            }
        });
    }
}

