/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.internal.widget.ListViewCompat;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.crescentflare.appconfig.activity.AppConfigStringChoiceActivity;
import com.crescentflare.appconfig.activity.EditAppConfigActivity;
import com.crescentflare.appconfig.adapter.AppConfigAdapter;
import com.crescentflare.appconfig.adapter.AppConfigAdapterEntry;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import com.crescentflare.appconfig.manager.AppConfigStorage;
import java.util.ArrayList;

public class ManageAppConfigActivity
extends AppCompatActivity {
    private static final int RESULT_CODE_CUSTOM_COPY_FROM = 1000;
    private static final int RESULT_CODE_EDIT_CONFIG = 1001;
    private FrameLayout layout = null;
    private ListView listView = null;
    private LinearLayout spinnerView = null;
    private AppConfigAdapter adapter = null;
    private int buildNr = -1;

    public static Intent newInstance(Context context) {
        return new Intent(context, ManageAppConfigActivity.class);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!AppConfigStorage.instance.isInitialized()) {
            this.finish();
            return;
        }
        try {
            PackageInfo info;
            PackageManager manager = this.getPackageManager();
            if (manager != null && (info = manager.getPackageInfo(this.getPackageName(), 0)) != null) {
                this.buildNr = info.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.layout = this.createContentView();
        this.setTitle(AppConfigResourceHelper.getString((Context)this, "app_config_title_list"));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.setContentView((View)this.layout);
        AppConfigStorage.instance.loadFromSource((Context)this, new Runnable(){

            @Override
            public void run() {
                ManageAppConfigActivity.this.populateContent();
            }
        });
    }

    public static void startWithResult(Activity fromActivity, int resultCode) {
        fromActivity.startActivityForResult(ManageAppConfigActivity.newInstance((Context)fromActivity), resultCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1000 && resultCode == -1) {
            String resultString = data.getStringExtra("ARG_INTENT_RESULT_SELECTED_STRING");
            if (resultString.length() > 0) {
                EditAppConfigActivity.startWithResult((Activity)this, resultString, true, 1001);
            }
        } else if (requestCode == 1001 && resultCode == -1) {
            this.populateContent();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private int dip(int pixels) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)pixels);
    }

    private FrameLayout createContentView() {
        this.layout = new FrameLayout((Context)this);
        this.listView = new ListViewCompat((Context)this);
        this.adapter = new AppConfigAdapter((Context)this);
        this.listView.setBackgroundColor(AppConfigResourceHelper.getColor((Context)this, "api_config_background"));
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.listView.setVisibility(8);
        this.layout.addView((View)this.listView);
        this.spinnerView = new LinearLayout((Context)this);
        this.spinnerView.setBackgroundColor(-1);
        this.spinnerView.setGravity(17);
        this.spinnerView.setOrientation(1);
        this.spinnerView.setPadding(this.dip(8), this.dip(8), this.dip(8), this.dip(8));
        this.layout.addView((View)this.spinnerView);
        ProgressBar iconView = new ProgressBar((Context)this);
        this.spinnerView.addView((View)iconView);
        String buildString = this.buildNr > 0 ? "\n(" + AppConfigResourceHelper.getString((Context)this, "app_config_field_build").toLowerCase() + ": " + this.buildNr + ")" : "";
        TextView progressTextView = new TextView((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.setMargins(0, this.dip(8), 0, 0);
        progressTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressTextView.setGravity(1);
        progressTextView.setText((CharSequence)(AppConfigResourceHelper.getString((Context)this, "app_config_loading") + buildString));
        this.spinnerView.addView((View)progressTextView);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                AppConfigAdapterEntry entry = (AppConfigAdapterEntry)parent.getItemAtPosition(position);
                if (entry.getType() == AppConfigAdapterEntry.Type.Configuration) {
                    if (entry.getName().length() > 0) {
                        AppConfigStorage.instance.selectConfig((Context)ManageAppConfigActivity.this, entry.getName());
                        ManageAppConfigActivity.this.setResult(-1);
                        ManageAppConfigActivity.this.finish();
                    } else {
                        ArrayList<String> configs = AppConfigStorage.instance.configList();
                        AppConfigStringChoiceActivity.startWithResult((Activity)ManageAppConfigActivity.this, AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_title_edit_new"), AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_header_choose_custom_copy"), configs, 1000);
                    }
                }
            }
        });
        this.listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
                AppConfigAdapterEntry entry = (AppConfigAdapterEntry)parent.getItemAtPosition(position);
                if (entry.getType() == AppConfigAdapterEntry.Type.Configuration) {
                    if (entry.getName().length() > 0) {
                        EditAppConfigActivity.startWithResult((Activity)ManageAppConfigActivity.this, entry.getName(), false, 1001);
                    } else {
                        ArrayList<String> configs = AppConfigStorage.instance.configList();
                        AppConfigStringChoiceActivity.startWithResult((Activity)ManageAppConfigActivity.this, AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_title_choose_custom_copy"), AppConfigResourceHelper.getString((Context)ManageAppConfigActivity.this, "app_config_header_choose_custom_copy"), configs, 1000);
                    }
                    return true;
                }
                return false;
            }
        });
        return this.layout;
    }

    private void populateContent() {
        this.spinnerView.setVisibility(8);
        this.listView.setVisibility(0);
        ArrayList<AppConfigAdapterEntry> entries = new ArrayList<AppConfigAdapterEntry>();
        ArrayList<String> configs = AppConfigStorage.instance.configList();
        if (configs.size() > 0) {
            entries.add(AppConfigAdapterEntry.entryForHeader(AppConfigResourceHelper.getString((Context)this, "app_config_header_list")));
            if (AppConfigStorage.instance.getSelectedConfig() != null) {
                String configName = AppConfigStorage.instance.getSelectedConfigName();
                entries.add(AppConfigAdapterEntry.entryForConfiguration(configName, AppConfigResourceHelper.getString((Context)this, "app_config_action_last_selection_prefix") + " " + configName.substring(0, 1).toLowerCase() + configName.substring(1), AppConfigStorage.instance.isConfigOverride(configName)));
            }
            for (String configName : configs) {
                entries.add(AppConfigAdapterEntry.entryForConfiguration(configName, AppConfigStorage.instance.isConfigOverride(configName)));
            }
        }
        ArrayList<String> customConfigs = AppConfigStorage.instance.customConfigList();
        entries.add(AppConfigAdapterEntry.entryForHeader(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_custom")));
        for (String configName : customConfigs) {
            if (!AppConfigStorage.instance.isCustomConfig(configName)) continue;
            entries.add(AppConfigAdapterEntry.entryForConfiguration(configName, true));
        }
        entries.add(AppConfigAdapterEntry.entryForConfiguration("", AppConfigResourceHelper.getString((Context)this, "app_config_action_add"), false));
        entries.add(AppConfigAdapterEntry.entryForHeader(AppConfigResourceHelper.getString((Context)this, "app_config_header_list_build_info")));
        entries.add(AppConfigAdapterEntry.entryForBuildInfo(AppConfigResourceHelper.getString((Context)this, "app_config_field_build"), "" + this.buildNr));
        entries.add(AppConfigAdapterEntry.entryForBuildInfo(AppConfigResourceHelper.getString((Context)this, "app_config_field_api_level"), "" + Build.VERSION.SDK_INT));
        entries.add(AppConfigAdapterEntry.entryForFooter());
        this.adapter.setEntries(entries);
    }
}

