/*
 * Decompiled with CFR 0.152.
 */
package com.createsend.models.transactional.request;

import com.createsend.models.subscribers.ConsentToTrack;
import com.createsend.models.transactional.request.Attachment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonIgnore;

public class SmartEmailRequest {
    @JsonIgnore
    private UUID smartEmailId;
    private List<String> to = new ArrayList<String>();
    private List<String> cc = new ArrayList<String>();
    private List<String> bcc = new ArrayList<String>();
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private Map<String, String> data = new HashMap<String, String>();
    private boolean addRecipientsToList;
    private ConsentToTrack consentToTrack;

    public SmartEmailRequest(UUID smartEmailId, String to, ConsentToTrack consentToTrack) {
        if (smartEmailId == null) {
            throw new IllegalArgumentException("Must supply a Smart Email ID");
        }
        if (to == null || to.length() == 0) {
            throw new IllegalArgumentException("Must supply a TO address");
        }
        if (consentToTrack == null) {
            throw new IllegalArgumentException("Must supply a ConsentToTrack value");
        }
        this.smartEmailId = smartEmailId;
        this.to.add(to);
        this.consentToTrack = consentToTrack;
    }

    public UUID getSmartEmailId() {
        return this.smartEmailId;
    }

    public void addTo(String recipient) {
        this.to.add(recipient);
    }

    public Iterator<String> getTo() {
        return this.to.iterator();
    }

    public void addCc(String recipient) {
        this.cc.add(recipient);
    }

    public Iterator<String> getCc() {
        return this.cc.iterator();
    }

    public void addBcc(String recipient) {
        this.bcc.add(recipient);
    }

    public Iterator<String> getBcc() {
        return this.bcc.iterator();
    }

    public void addData(String name, String value) {
        this.data.put(name, value);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAddRecipientsToList(boolean addRecipientsToList) {
        this.addRecipientsToList = addRecipientsToList;
    }

    public boolean isAddRecipientsToList() {
        return this.addRecipientsToList;
    }

    public ConsentToTrack getConsentToTrack() {
        return this.consentToTrack;
    }

    public void setConsentToTrack(ConsentToTrack consentToTrack) {
        this.consentToTrack = consentToTrack;
    }
}

