/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.people.Person;
import com.createsend.models.people.PersonResult;
import com.createsend.models.people.PersonToAdd;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;

public class People
extends CreateSendBase {
    private String clientID;

    public People(AuthenticationDetails auth, String clientID) {
        this.setClientID(clientID);
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String add(PersonToAdd person) throws CreateSendException {
        return this.jerseyClient.post(PersonResult.class, (Object)person, (String[])new String[]{"clients", this.clientID, "people.json"}).EmailAddress;
    }

    public Person details(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        return this.jerseyClient.get(Person.class, (MultivaluedMap<String, String>)queryString, "clients", this.clientID, "people.json");
    }

    public void delete(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        this.jerseyClient.delete((MultivaluedMap<String, String>)queryString, "clients", this.clientID, "people.json");
    }

    public void update(String originalEmailAddress, Person newDetails) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)originalEmailAddress);
        this.jerseyClient.put((Object)newDetails, (MultivaluedMap<String, String>)queryString, "clients", this.clientID, "people.json");
    }
}

