/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.PagedResult;
import com.createsend.models.campaigns.CampaignClick;
import com.createsend.models.campaigns.CampaignForCreation;
import com.createsend.models.campaigns.CampaignForCreationFromTemplate;
import com.createsend.models.campaigns.CampaignOpen;
import com.createsend.models.campaigns.CampaignSummary;
import com.createsend.models.campaigns.EmailClient;
import com.createsend.models.campaigns.ListsAndSegments;
import com.createsend.models.campaigns.PreviewData;
import com.createsend.models.campaigns.Schedule;
import com.createsend.models.subscribers.BouncedSubscriber;
import com.createsend.models.subscribers.Subscriber;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.ErrorDeserialiser;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.createsend.util.jersey.JsonProvider;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;

public class Campaigns
extends CreateSendBase {
    private String campaignID;

    public Campaigns(AuthenticationDetails auth) {
        this(auth, null);
    }

    public Campaigns(AuthenticationDetails auth, String campaignID) {
        this.setCampaignID(campaignID);
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public String getCampaignID() {
        return this.campaignID;
    }

    public void setCampaignID(String campaignID) {
        this.campaignID = campaignID;
    }

    public String create(String clientID, CampaignForCreation campaign) throws CreateSendException {
        this.campaignID = this.jerseyClient.post(String.class, (Object)campaign, "campaigns", clientID + ".json");
        return this.campaignID;
    }

    public String createFromTemplate(String clientID, CampaignForCreationFromTemplate campaign) throws CreateSendException {
        this.campaignID = this.jerseyClient.post(String.class, (Object)campaign, "campaigns", clientID + "/fromtemplate.json");
        return this.campaignID;
    }

    public void send(String confirmationEmail, Date sendDate) throws CreateSendException {
        Schedule sched = new Schedule();
        sched.ConfirmationEmail = confirmationEmail;
        sched.SendDate = sendDate == null ? "Immediately" : JsonProvider.ApiDateFormat.format(sendDate);
        this.jerseyClient.post(String.class, (Object)sched, "campaigns", this.campaignID, "send.json");
    }

    public void unschedule() throws CreateSendException {
        this.jerseyClient.post(String.class, (Object)"", "campaigns", this.campaignID, "unschedule.json");
    }

    public void test(PreviewData data) throws CreateSendException {
        this.jerseyClient.post(String.class, (Object)data, new ErrorDeserialiser(), "campaigns", this.campaignID, "sendpreview.json");
    }

    public CampaignSummary summary() throws CreateSendException {
        return this.jerseyClient.get(CampaignSummary.class, "campaigns", this.campaignID, "summary.json");
    }

    public EmailClient[] emailClientUsage() throws CreateSendException {
        return this.jerseyClient.get(EmailClient[].class, "campaigns", this.campaignID, "emailclientusage.json");
    }

    public ListsAndSegments listsAndSegments() throws CreateSendException {
        return this.jerseyClient.get(ListsAndSegments.class, "campaigns", this.campaignID, "listsandsegments.json");
    }

    public PagedResult<Subscriber> recipients(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, null, "campaigns", this.campaignID, "recipients.json");
    }

    public PagedResult<BouncedSubscriber> bounces() throws CreateSendException {
        return this.bounces(1, 1000, "date", "asc");
    }

    public PagedResult<BouncedSubscriber> bounces(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.bounces("", page, pageSize, orderField, orderDirection);
    }

    public PagedResult<BouncedSubscriber> bounces(Date bouncesFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.bounces(JsonProvider.ApiDateFormat.format(bouncesFrom), page, pageSize, orderField, orderDirection);
    }

    private PagedResult<BouncedSubscriber> bounces(String bouncesFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)bouncesFrom);
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "campaigns", this.campaignID, "bounces.json");
    }

    public PagedResult<CampaignOpen> opens() throws CreateSendException {
        return this.opens(1, 1000, "date", "asc");
    }

    public PagedResult<CampaignOpen> opens(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.opens("", page, pageSize, orderField, orderDirection);
    }

    public PagedResult<CampaignOpen> opens(Date opensFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.opens(JsonProvider.ApiDateFormat.format(opensFrom), page, pageSize, orderField, orderDirection);
    }

    private PagedResult<CampaignOpen> opens(String opensFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)opensFrom);
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "campaigns", this.campaignID, "opens.json");
    }

    public PagedResult<CampaignClick> clicks() throws CreateSendException {
        return this.clicks(1, 1000, "date", "asc");
    }

    public PagedResult<CampaignClick> clicks(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.clicks("", page, pageSize, orderField, orderDirection);
    }

    public PagedResult<CampaignClick> clicks(Date clicksFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.clicks(JsonProvider.ApiDateFormat.format(clicksFrom), page, pageSize, orderField, orderDirection);
    }

    private PagedResult<CampaignClick> clicks(String clicksFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)clicksFrom);
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "campaigns", this.campaignID, "clicks.json");
    }

    public PagedResult<Subscriber> unsubscribes() throws CreateSendException {
        return this.unsubscribes(1, 1000, "date", "asc");
    }

    public PagedResult<Subscriber> unsubscribes(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.unsubscribes("", page, pageSize, orderField, orderDirection);
    }

    public PagedResult<Subscriber> unsubscribes(Date unsubscribesFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.unsubscribes(JsonProvider.ApiDateFormat.format(unsubscribesFrom), page, pageSize, orderField, orderDirection);
    }

    private PagedResult<Subscriber> unsubscribes(String unsubscribesFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)unsubscribesFrom);
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "campaigns", this.campaignID, "unsubscribes.json");
    }

    public PagedResult<Subscriber> spamComplaints() throws CreateSendException {
        return this.spamComplaints(1, 1000, "date", "asc");
    }

    public PagedResult<Subscriber> spamComplaints(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.spamComplaints("", page, pageSize, orderField, orderDirection);
    }

    public PagedResult<Subscriber> spamComplaints(Date spamComplaintsFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.spamComplaints(JsonProvider.ApiDateFormat.format(spamComplaintsFrom), page, pageSize, orderField, orderDirection);
    }

    private PagedResult<Subscriber> spamComplaints(String spamComplaintsFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)spamComplaintsFrom);
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "campaigns", this.campaignID, "spam.json");
    }

    public void delete() throws CreateSendException {
        this.jerseyClient.delete("campaigns", this.campaignID + ".json");
    }
}

