/*
 * Decompiled with CFR 0.152.
 */
package com.crazyhitty.chdev.ks.rssmanager;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.crazyhitty.chdev.ks.rssmanager.RSS;
import com.crazyhitty.chdev.ks.rssmanager.RssParser;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.simpleframework.xml.core.Persister;

public class RssReader {
    private static final String TAG = "RssReader";
    private static RssReader rssReaderInstance;
    private RssCallback rssCallback;

    private RssReader() {
    }

    public static RssReader getInstance() {
        if (rssReaderInstance == null) {
            rssReaderInstance = new RssReader();
        }
        return rssReaderInstance;
    }

    public RssReader callback(RssCallback rssCallback) {
        RssReader.rssReaderInstance.rssCallback = rssCallback;
        return rssReaderInstance;
    }

    public void loadFeeds(String ... urls) {
        RssParser.parse(urls[0]).enqueue(new Callback(){

            public void onFailure(Call call, final IOException e) {
                Log.e((String)RssReader.TAG, (String)"onFailure", (Throwable)e);
                if (rssReaderInstance.rssCallback != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            rssReaderInstance.rssCallback.unableToReadRssFeeds(e.getMessage());
                        }
                    });
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                Log.d((String)RssReader.TAG, (String)("onResponse: responseCode: " + response.code()));
                if (rssReaderInstance.rssCallback != null) {
                    try {
                        final RSS rss = (RSS)new Persister().read(RSS.class, response.body().string());
                        Log.d((String)RssReader.TAG, (String)("onResponse: RssParsed: " + rss.toString()));
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                rssReaderInstance.rssCallback.rssFeedsLoaded(rss);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                rssReaderInstance.rssCallback.unableToReadRssFeeds(e.getMessage());
                            }
                        });
                    }
                }
            }
        });
    }

    public static interface RssCallback {
        public void rssFeedsLoaded(RSS ... var1);

        public void unableToReadRssFeeds(String var1);
    }
}

