/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.common.pagination;

import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.service.service.common.CozeLoggerFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;

public class PageNumBasedPaginator<T>
implements Iterator<T> {
    private final PageFetcher<T> pageFetcher;
    private final int pageSize;
    private static final Logger logger = CozeLoggerFactory.getLogger();
    private Iterator<T> currentIterator;
    private PageResponse<T> currentPage;
    private int currentPageNum = 1;

    public PageNumBasedPaginator(PageFetcher<T> pageFetcher, int pageSize) {
        this.pageFetcher = pageFetcher;
        this.pageSize = pageSize;
        this.fetchNextPage();
    }

    private void fetchNextPage() {
        PageRequest request = PageRequest.builder().pageNum(this.currentPageNum).pageSize(this.pageSize).build();
        this.currentPage = this.pageFetcher.fetch(request);
        logger.info("Fetched page: {} success, got{} items", (Object)this.currentPageNum, (Object)this.currentPage.getData().size());
        this.currentIterator = this.currentPage.getData().iterator();
        ++this.currentPageNum;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        if (this.currentPage.isHasMore()) {
            logger.info("Fetching next page: {}", (Object)this.currentPageNum);
            this.fetchNextPage();
            return this.currentIterator.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }
}

