/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.websocket.chat;

import com.coze.openapi.client.connversations.message.model.Message;
import com.coze.openapi.client.websocket.event.downstream.ChatCreatedEvent;
import com.coze.openapi.client.websocket.event.downstream.ChatUpdatedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationAudioCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationAudioDeltaEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationAudioTranscriptCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationAudioTranscriptUpdateEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationChatCanceledEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationChatCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationChatCreatedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationChatFailedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationChatInProgressEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationChatRequiresActionEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationClearedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationMessageCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.ConversationMessageDeltaEvent;
import com.coze.openapi.client.websocket.event.downstream.ErrorEvent;
import com.coze.openapi.client.websocket.event.downstream.InputAudioBufferClearedEvent;
import com.coze.openapi.client.websocket.event.downstream.InputAudioBufferCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.InputAudioBufferSpeechStartedEvent;
import com.coze.openapi.client.websocket.event.downstream.InputAudioBufferSpeechStoppedEvent;
import com.coze.openapi.client.websocket.event.model.ChatUpdateEventData;
import com.coze.openapi.client.websocket.event.upstream.ChatUpdateEvent;
import com.coze.openapi.client.websocket.event.upstream.ConversationChatCancelEvent;
import com.coze.openapi.client.websocket.event.upstream.ConversationChatSubmitToolOutputsEvent;
import com.coze.openapi.client.websocket.event.upstream.ConversationClearEvent;
import com.coze.openapi.client.websocket.event.upstream.ConversationMessageCreateEvent;
import com.coze.openapi.client.websocket.event.upstream.InputAudioBufferAppendEvent;
import com.coze.openapi.client.websocket.event.upstream.InputAudioBufferClearEvent;
import com.coze.openapi.client.websocket.event.upstream.InputAudioBufferCompleteEvent;
import com.coze.openapi.service.service.websocket.chat.WebsocketsChatCallbackHandler;
import com.coze.openapi.service.service.websocket.chat.WebsocketsChatCreateReq;
import com.coze.openapi.service.service.websocket.common.BaseCallbackHandler;
import com.coze.openapi.service.service.websocket.common.BaseWebsocketsClient;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;

public class WebsocketsChatClient
extends BaseWebsocketsClient {
    private final ObjectMapper objectMapper = Utils.getMapper();
    private final WebsocketsChatCallbackHandler handler;
    private static final String uri = "/v1/chat";

    protected WebsocketsChatClient(OkHttpClient client, String wsHost, WebsocketsChatCreateReq req) {
        super(client, WebsocketsChatClient.buildUrl(wsHost, req), req.getCallbackHandler(), req);
        this.handler = req.getCallbackHandler();
    }

    protected static String buildUrl(String wsHost, WebsocketsChatCreateReq req) {
        return String.format("%s%s?bot_id=%s", wsHost, uri, req.getBotID());
    }

    public void chatUpdate(ChatUpdateEventData data) {
        this.sendEvent(((ChatUpdateEvent.ChatUpdateEventBuilder)ChatUpdateEvent.builder().data(data)).build());
    }

    public void conversationChatCancel() {
        this.sendEvent(new ConversationChatCancelEvent());
    }

    public void conversationChatSubmitToolOutputs(ConversationChatSubmitToolOutputsEvent.Data data) {
        this.sendEvent(((ConversationChatSubmitToolOutputsEvent.ConversationChatSubmitToolOutputsEventBuilder)ConversationChatSubmitToolOutputsEvent.builder().data(data)).build());
    }

    public void conversationClear() {
        this.sendEvent(new ConversationClearEvent());
    }

    public void conversationMessageCreate(Message data) {
        this.sendEvent(((ConversationMessageCreateEvent.ConversationMessageCreateEventBuilder)ConversationMessageCreateEvent.builder().data(data)).build());
    }

    public void inputAudioBufferAppend(String data) {
        this.sendEvent(InputAudioBufferAppendEvent.of(Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8))));
    }

    public void inputAudioBufferAppend(byte[] data) {
        this.sendEvent(InputAudioBufferAppendEvent.of(Base64.getEncoder().encodeToString(data)));
    }

    public void inputAudioBufferClear() {
        this.sendEvent(new InputAudioBufferClearEvent());
    }

    public void inputAudioBufferComplete() {
        this.sendEvent(new InputAudioBufferCompleteEvent());
    }

    @Override
    protected BaseCallbackHandler getCallbackHandler() {
        return this.handler;
    }

    @Override
    protected void handleEvent(WebSocket ws, String text) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(text);
            String eventType = this.parseEventType(jsonNode, text);
            if (eventType == null) {
                return;
            }
            switch (eventType) {
                case "chat.created": {
                    ChatCreatedEvent chatCreatedEvent = (ChatCreatedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ChatCreatedEvent.class);
                    this.handler.onChatCreated(this, chatCreatedEvent);
                    break;
                }
                case "chat.updated": {
                    ChatUpdatedEvent chatUpdatedEvent = (ChatUpdatedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ChatUpdatedEvent.class);
                    this.handler.onChatUpdated(this, chatUpdatedEvent);
                    break;
                }
                case "conversation.audio.completed": {
                    ConversationAudioCompletedEvent audioCompletedEvent = (ConversationAudioCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationAudioCompletedEvent.class);
                    this.handler.onConversationAudioCompleted(this, audioCompletedEvent);
                    break;
                }
                case "conversation.audio.delta": {
                    ConversationAudioDeltaEvent audioDeltaEvent = (ConversationAudioDeltaEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationAudioDeltaEvent.class);
                    this.handler.onConversationAudioDelta(this, audioDeltaEvent);
                    break;
                }
                case "conversation.audio_transcript.completed": {
                    ConversationAudioTranscriptCompletedEvent transcriptCompletedEvent = (ConversationAudioTranscriptCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationAudioTranscriptCompletedEvent.class);
                    this.handler.onConversationAudioTranscriptCompleted(this, transcriptCompletedEvent);
                    break;
                }
                case "conversation.audio_transcript.update": {
                    ConversationAudioTranscriptUpdateEvent transcriptUpdateEvent = (ConversationAudioTranscriptUpdateEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationAudioTranscriptUpdateEvent.class);
                    this.handler.onConversationAudioTranscriptUpdate(this, transcriptUpdateEvent);
                    break;
                }
                case "conversation.chat.canceled": {
                    ConversationChatCanceledEvent chatCanceledEvent = (ConversationChatCanceledEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationChatCanceledEvent.class);
                    this.handler.onConversationChatCanceled(this, chatCanceledEvent);
                    break;
                }
                case "conversation.chat.completed": {
                    ConversationChatCompletedEvent chatCompletedEvent = (ConversationChatCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationChatCompletedEvent.class);
                    this.handler.onConversationChatCompleted(this, chatCompletedEvent);
                    break;
                }
                case "conversation.chat.created": {
                    ConversationChatCreatedEvent conversationChatCreatedEvent = (ConversationChatCreatedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationChatCreatedEvent.class);
                    this.handler.onConversationChatCreated(this, conversationChatCreatedEvent);
                    break;
                }
                case "conversation.chat.failed": {
                    ConversationChatFailedEvent chatFailedEvent = (ConversationChatFailedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationChatFailedEvent.class);
                    this.handler.onConversationChatFailed(this, chatFailedEvent);
                    break;
                }
                case "conversation.chat.in_progress": {
                    ConversationChatInProgressEvent chatInProgressEvent = (ConversationChatInProgressEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationChatInProgressEvent.class);
                    this.handler.onConversationChatInProgress(this, chatInProgressEvent);
                    break;
                }
                case "conversation.chat.requires_action": {
                    ConversationChatRequiresActionEvent chatRequiresActionEvent = (ConversationChatRequiresActionEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationChatRequiresActionEvent.class);
                    this.handler.onConversationChatRequiresAction(this, chatRequiresActionEvent);
                    break;
                }
                case "conversation.cleared": {
                    ConversationClearedEvent clearedEvent = (ConversationClearedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationClearedEvent.class);
                    this.handler.onConversationCleared(this, clearedEvent);
                    break;
                }
                case "conversation.message.completed": {
                    ConversationMessageCompletedEvent messageCompletedEvent = (ConversationMessageCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationMessageCompletedEvent.class);
                    this.handler.onConversationMessageCompleted(this, messageCompletedEvent);
                    break;
                }
                case "conversation.message.delta": {
                    ConversationMessageDeltaEvent messageDeltaEvent = (ConversationMessageDeltaEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ConversationMessageDeltaEvent.class);
                    this.handler.onConversationMessageDelta(this, messageDeltaEvent);
                    break;
                }
                case "input_audio_buffer.cleared": {
                    InputAudioBufferClearedEvent bufferClearedEvent = (InputAudioBufferClearedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, InputAudioBufferClearedEvent.class);
                    this.handler.onInputAudioBufferCleared(this, bufferClearedEvent);
                    break;
                }
                case "input_audio_buffer.completed": {
                    InputAudioBufferCompletedEvent bufferCompletedEvent = (InputAudioBufferCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, InputAudioBufferCompletedEvent.class);
                    this.handler.onInputAudioBufferCompleted(this, bufferCompletedEvent);
                    break;
                }
                case "input_audio_buffer.speech_started": {
                    InputAudioBufferSpeechStartedEvent speechStartedEvent = (InputAudioBufferSpeechStartedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, InputAudioBufferSpeechStartedEvent.class);
                    this.handler.onInputAudioBufferSpeechStarted(this, speechStartedEvent);
                    break;
                }
                case "input_audio_buffer.speech_stopped": {
                    InputAudioBufferSpeechStoppedEvent speechStoppedEvent = (InputAudioBufferSpeechStoppedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, InputAudioBufferSpeechStoppedEvent.class);
                    this.handler.onInputAudioBufferSpeechStopped(this, speechStoppedEvent);
                    break;
                }
                case "error": {
                    ErrorEvent errorEvent = (ErrorEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ErrorEvent.class);
                    this.handler.onError(this, errorEvent);
                    break;
                }
                default: {
                    logger.error("unknown event type: {}, event string: {}", (Object)eventType, (Object)text);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handler.onClientException(this, new RuntimeException(e));
        }
    }
}

