/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.audio;

import com.coze.openapi.api.AudioVoiceAPI;
import com.coze.openapi.client.audio.voices.CloneVoiceReq;
import com.coze.openapi.client.audio.voices.CloneVoiceResp;
import com.coze.openapi.client.audio.voices.ListVoiceReq;
import com.coze.openapi.client.audio.voices.ListVoiceResp;
import com.coze.openapi.client.audio.voices.model.Voice;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageNumBasedPaginator;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.service.utils.Utils;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class VoiceService {
    private final AudioVoiceAPI api;

    public VoiceService(AudioVoiceAPI api) {
        this.api = api;
    }

    public CloneVoiceResp clone(CloneVoiceReq req) {
        MediaType textPlainType = MediaType.parse((String)"text/plain");
        RequestBody voiceName = RequestBody.create((MediaType)textPlainType, (String)req.getVoiceName());
        RequestBody audioFormat = RequestBody.create((MediaType)textPlainType, (String)req.getAudioFormat().getValue());
        RequestBody language = null;
        if (req.getLanguage() != null) {
            language = RequestBody.create((MediaType)textPlainType, (String)req.getLanguage().getValue());
        }
        RequestBody voiceID = null;
        if (req.getVoiceID() != null) {
            voiceID = RequestBody.create((MediaType)textPlainType, (String)req.getVoiceID());
        }
        RequestBody previewText = null;
        if (req.getPreviewText() != null) {
            previewText = RequestBody.create((MediaType)textPlainType, (String)req.getPreviewText());
        }
        RequestBody text = null;
        if (req.getText() != null) {
            text = RequestBody.create((MediaType)textPlainType, (String)req.getText());
        }
        File file = new File(req.getFilePath());
        MediaType formDataType = MediaType.parse((String)"multipart/form-data");
        RequestBody fileBody = RequestBody.create((MediaType)formDataType, (File)file);
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        return Utils.execute(this.api.clone(filePart, voiceName, audioFormat, language, voiceID, previewText, text, req)).getData();
    }

    public PageResp<Voice> list(ListVoiceReq req) {
        if (req == null) {
            throw new IllegalArgumentException("req is required");
        }
        Integer pageNum = req.getPageNum();
        Integer pageSize = req.getPageSize();
        Boolean filterSystemVoice = req.getFilterSystemVoice();
        PageFetcher pageFetcher = request -> {
            ListVoiceResp resp = Utils.execute(this.api.list(filterSystemVoice, request.getPageNum(), request.getPageSize(), req)).getData();
            return PageResponse.builder().hasMore(resp.getVoiceList().size() == request.getPageSize().intValue()).data(resp.getVoiceList()).pageNum(request.getPageNum()).pageSize(request.getPageSize()).logID(resp.getLogID()).build();
        };
        PageNumBasedPaginator paginator = new PageNumBasedPaginator(pageFetcher, pageSize);
        PageRequest initialRequest = PageRequest.builder().pageNum(pageNum).pageSize(pageSize).build();
        PageResponse currentPage = pageFetcher.fetch(initialRequest);
        return PageResp.builder().items(currentPage.getData()).iterator(paginator).hasMore(currentPage.isHasMore()).logID(currentPage.getLogID()).build();
    }
}

