/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.auth;

import com.coze.openapi.client.auth.GetAccessTokenReq;
import com.coze.openapi.client.auth.GetJWTAccessTokenReq;
import com.coze.openapi.client.auth.GrantType;
import com.coze.openapi.client.auth.LoadAuthConfig;
import com.coze.openapi.client.auth.OAuthConfig;
import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.client.auth.scope.Scope;
import com.coze.openapi.service.auth.DefaultJWTBuilder;
import com.coze.openapi.service.auth.JWTBuilder;
import com.coze.openapi.service.auth.JWTPayload;
import com.coze.openapi.service.auth.OAuthClient;
import com.coze.openapi.service.utils.Utils;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;

public class JWTOAuthClient
extends OAuthClient {
    private final Integer ttl;
    private final PrivateKey privateKey;
    private final String publicKey;
    private final JWTBuilder jwtBuilder;

    protected JWTOAuthClient(JWTOAuthBuilder builder) throws Exception {
        super(builder);
        this.privateKey = this.parsePrivateKey(builder.privateKey);
        this.publicKey = builder.publicKey;
        this.jwtBuilder = builder.jwtBuilder != null ? builder.jwtBuilder : new DefaultJWTBuilder();
        this.ttl = builder.ttl;
    }

    public static JWTOAuthClient loadFromConfig(LoadAuthConfig loadConfig) throws Exception {
        OAuthConfig config = OAuthConfig.load(loadConfig);
        return ((JWTOAuthBuilder)((JWTOAuthBuilder)new JWTOAuthBuilder().privateKey(config.getPrivateKey()).publicKey(config.getPublicKeyId()).clientID(config.getClientId())).baseURL(config.getCozeApiBase())).build();
    }

    @Override
    public OAuthToken refreshToken(String refreshToken) {
        return null;
    }

    public OAuthToken getAccessToken() {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().ttl(this.ttl).build());
    }

    public OAuthToken getAccessToken(Integer ttl) {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().ttl(ttl).build());
    }

    public OAuthToken getAccessToken(Scope scope) {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().scope(scope).ttl(this.ttl).build());
    }

    public OAuthToken getAccessToken(Integer ttl, Scope scope) {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().scope(scope).ttl(ttl).build());
    }

    public OAuthToken getAccessToken(String sessionName) {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().sessionName(sessionName).ttl(this.ttl).build());
    }

    public OAuthToken getAccessToken(Integer ttl, String sessionName) {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().sessionName(sessionName).ttl(ttl).build());
    }

    public OAuthToken getAccessToken(Scope scope, String sessionName) {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().sessionName(sessionName).scope(scope).ttl(this.ttl).build());
    }

    public OAuthToken getAccessToken(Integer ttl, Scope scope, String sessionName) {
        return this.doGetAccessToken(GetJWTAccessTokenReq.builder().sessionName(sessionName).scope(scope).ttl(ttl).build());
    }

    public OAuthToken getAccessToken(GetJWTAccessTokenReq req) {
        return this.doGetAccessToken(req);
    }

    private OAuthToken doGetAccessToken(GetJWTAccessTokenReq req) {
        GetAccessTokenReq.GetAccessTokenReqBuilder<?, ?> builder = GetAccessTokenReq.builder();
        Integer ttl = this.ttl;
        if (req.getTtl() != null) {
            ttl = req.getTtl();
        }
        ((GetAccessTokenReq.GetAccessTokenReqBuilder)((GetAccessTokenReq.GetAccessTokenReqBuilder)builder.grantType(GrantType.JWT_CODE.getValue())).durationSeconds(ttl)).scope(req.getScope());
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("alg", "RS256");
        header.put("typ", "JWT");
        header.put("kid", this.publicKey);
        long now = System.currentTimeMillis() / 1000L;
        JWTPayload payload = JWTPayload.builder().iss(this.clientID).aud(this.hostName).exp(new Date((now + (long)ttl.intValue()) * 1000L)).iat(new Date(now * 1000L)).sessionName(req.getSessionName()).jti(Utils.genRandomSign(16)).sessionContext(req.getSessionContext()).build();
        String jwtToken = this.jwtBuilder.generateJWT(this.privateKey, header, payload);
        if (req.getAccountID() != null) {
            return this.getAccountAccessToken(jwtToken, String.valueOf(req.getAccountID()), (GetAccessTokenReq)builder.build());
        }
        if (req.getEnterpriseID() != null) {
            return this.getEnterpriseAccessToken(jwtToken, req.getEnterpriseID(), (GetAccessTokenReq)builder.build());
        }
        return this.getAccessToken(jwtToken, (GetAccessTokenReq)builder.build());
    }

    private PrivateKey parsePrivateKey(String privateKeyPEM) throws Exception {
        String privateKeyContent = privateKeyPEM.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] privateKeyBytes = Base64.getDecoder().decode(privateKeyContent);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public static class JWTOAuthBuilder
    extends OAuthClient.OAuthBuilder<JWTOAuthBuilder> {
        private Integer ttl;
        private String publicKey;
        private String privateKey;
        private JWTBuilder jwtBuilder;

        public JWTOAuthBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public JWTOAuthBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public JWTOAuthBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public JWTOAuthBuilder jwtBuilder(JWTBuilder jwtBuilder) {
            this.jwtBuilder = jwtBuilder;
            return this;
        }

        @Override
        protected JWTOAuthBuilder self() {
            return this;
        }

        @Override
        public JWTOAuthClient build() throws Exception {
            if (this.ttl == null || this.ttl.equals(0)) {
                this.ttl = 900;
            }
            return new JWTOAuthClient(this);
        }
    }
}

