/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.dataset.document.model;

import com.coze.openapi.client.dataset.document.model.DocumentSourceInfo;
import com.coze.openapi.client.dataset.document.model.DocumentUpdateRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;

public class DocumentBase {
    @JsonProperty(value="name")
    @NonNull
    private String name;
    @JsonProperty(value="source_info")
    @NonNull
    private DocumentSourceInfo sourceInfo;
    @JsonProperty(value="update_rule")
    private DocumentUpdateRule updateRule;

    public static DocumentBase buildWebPage(String name, String url) {
        return DocumentBase.builder().name(name).sourceInfo(DocumentSourceInfo.buildWebPage(url)).updateRule(DocumentUpdateRule.buildNoAutoUpdate()).build();
    }

    public static DocumentBase buildWebPage(String name, String url, Integer interval) {
        return DocumentBase.builder().name(name).sourceInfo(DocumentSourceInfo.buildWebPage(url)).updateRule(DocumentUpdateRule.buildAutoUpdate(interval)).build();
    }

    public static DocumentBase buildLocalFile(String name, byte[] content, String fileType) {
        return DocumentBase.builder().name(name).sourceInfo(DocumentSourceInfo.buildLocalFile(content, fileType)).build();
    }

    public static DocumentBase buildLocalFile(String name, String content, String fileType) {
        return DocumentBase.builder().name(name).sourceInfo(DocumentSourceInfo.buildLocalFile(content, fileType)).build();
    }

    public static DocumentBase buildImage(String name, Long fileID) {
        return DocumentBase.builder().name(name).sourceInfo(DocumentSourceInfo.buildImage(fileID)).build();
    }

    public static DocumentBaseBuilder builder() {
        return new DocumentBaseBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public DocumentSourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public DocumentUpdateRule getUpdateRule() {
        return this.updateRule;
    }

    @JsonProperty(value="name")
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="source_info")
    public void setSourceInfo(@NonNull DocumentSourceInfo sourceInfo) {
        if (sourceInfo == null) {
            throw new NullPointerException("sourceInfo is marked non-null but is null");
        }
        this.sourceInfo = sourceInfo;
    }

    @JsonProperty(value="update_rule")
    public void setUpdateRule(DocumentUpdateRule updateRule) {
        this.updateRule = updateRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentBase)) {
            return false;
        }
        DocumentBase other = (DocumentBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DocumentSourceInfo this$sourceInfo = this.getSourceInfo();
        DocumentSourceInfo other$sourceInfo = other.getSourceInfo();
        if (this$sourceInfo == null ? other$sourceInfo != null : !this$sourceInfo.equals(other$sourceInfo)) {
            return false;
        }
        DocumentUpdateRule this$updateRule = this.getUpdateRule();
        DocumentUpdateRule other$updateRule = other.getUpdateRule();
        return !(this$updateRule == null ? other$updateRule != null : !this$updateRule.equals(other$updateRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DocumentSourceInfo $sourceInfo = this.getSourceInfo();
        result = result * 59 + ($sourceInfo == null ? 43 : $sourceInfo.hashCode());
        DocumentUpdateRule $updateRule = this.getUpdateRule();
        result = result * 59 + ($updateRule == null ? 43 : $updateRule.hashCode());
        return result;
    }

    public String toString() {
        return "DocumentBase(name=" + this.getName() + ", sourceInfo=" + this.getSourceInfo() + ", updateRule=" + this.getUpdateRule() + ")";
    }

    public DocumentBase() {
    }

    public DocumentBase(@NonNull String name, @NonNull DocumentSourceInfo sourceInfo, DocumentUpdateRule updateRule) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (sourceInfo == null) {
            throw new NullPointerException("sourceInfo is marked non-null but is null");
        }
        this.name = name;
        this.sourceInfo = sourceInfo;
        this.updateRule = updateRule;
    }

    public static class DocumentBaseBuilder {
        private String name;
        private DocumentSourceInfo sourceInfo;
        private DocumentUpdateRule updateRule;

        DocumentBaseBuilder() {
        }

        @JsonProperty(value="name")
        public DocumentBaseBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @JsonProperty(value="source_info")
        public DocumentBaseBuilder sourceInfo(@NonNull DocumentSourceInfo sourceInfo) {
            if (sourceInfo == null) {
                throw new NullPointerException("sourceInfo is marked non-null but is null");
            }
            this.sourceInfo = sourceInfo;
            return this;
        }

        @JsonProperty(value="update_rule")
        public DocumentBaseBuilder updateRule(DocumentUpdateRule updateRule) {
            this.updateRule = updateRule;
            return this;
        }

        public DocumentBase build() {
            return new DocumentBase(this.name, this.sourceInfo, this.updateRule);
        }

        public String toString() {
            return "DocumentBase.DocumentBaseBuilder(name=" + this.name + ", sourceInfo=" + this.sourceInfo + ", updateRule=" + this.updateRule + ")";
        }
    }
}

