/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.connversations.message;

import com.coze.openapi.client.common.BaseReq;
import com.coze.openapi.client.connversations.message.model.MessageContentType;
import com.coze.openapi.client.connversations.message.model.MessageObjectString;
import com.coze.openapi.client.connversations.message.model.MessageRole;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class CreateMessageReq
extends BaseReq {
    @JsonProperty(value="conversation_id")
    @NonNull
    private String conversationID;
    @NonNull
    private MessageRole role;
    private String content;
    @JsonProperty(value="content_type")
    @NonNull
    private MessageContentType contentType;
    @JsonProperty(value="meta_data")
    private Map<String, String> metadata;

    public void setObjectContent(List<MessageObjectString> objects) {
        this.content = Utils.toJson(objects);
        this.contentType = MessageContentType.OBJECT_STRING;
    }

    protected CreateMessageReq(CreateMessageReqBuilder<?, ?> b) {
        super(b);
        this.conversationID = ((CreateMessageReqBuilder)b).conversationID;
        if (this.conversationID == null) {
            throw new NullPointerException("conversationID is marked non-null but is null");
        }
        this.role = ((CreateMessageReqBuilder)b).role;
        if (this.role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.content = ((CreateMessageReqBuilder)b).content;
        this.contentType = ((CreateMessageReqBuilder)b).contentType;
        if (this.contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        this.metadata = ((CreateMessageReqBuilder)b).metadata;
    }

    public static CreateMessageReqBuilder<?, ?> builder() {
        return new CreateMessageReqBuilderImpl();
    }

    @NonNull
    public String getConversationID() {
        return this.conversationID;
    }

    @NonNull
    public MessageRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    @NonNull
    public MessageContentType getContentType() {
        return this.contentType;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="conversation_id")
    public void setConversationID(@NonNull String conversationID) {
        if (conversationID == null) {
            throw new NullPointerException("conversationID is marked non-null but is null");
        }
        this.conversationID = conversationID;
    }

    public void setRole(@NonNull MessageRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="content_type")
    public void setContentType(@NonNull MessageContentType contentType) {
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        this.contentType = contentType;
    }

    @JsonProperty(value="meta_data")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return "CreateMessageReq(conversationID=" + this.getConversationID() + ", role=" + this.getRole() + ", content=" + this.getContent() + ", contentType=" + this.getContentType() + ", metadata=" + this.getMetadata() + ")";
    }

    public CreateMessageReq() {
    }

    public CreateMessageReq(@NonNull String conversationID, @NonNull MessageRole role, String content, @NonNull MessageContentType contentType, Map<String, String> metadata) {
        if (conversationID == null) {
            throw new NullPointerException("conversationID is marked non-null but is null");
        }
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        this.conversationID = conversationID;
        this.role = role;
        this.content = content;
        this.contentType = contentType;
        this.metadata = metadata;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateMessageReq)) {
            return false;
        }
        CreateMessageReq other = (CreateMessageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$conversationID = this.getConversationID();
        String other$conversationID = other.getConversationID();
        if (this$conversationID == null ? other$conversationID != null : !this$conversationID.equals(other$conversationID)) {
            return false;
        }
        MessageRole this$role = this.getRole();
        MessageRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        MessageContentType this$contentType = this.getContentType();
        MessageContentType other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateMessageReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $conversationID = this.getConversationID();
        result = result * 59 + ($conversationID == null ? 43 : $conversationID.hashCode());
        MessageRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        MessageContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    private static final class CreateMessageReqBuilderImpl
    extends CreateMessageReqBuilder<CreateMessageReq, CreateMessageReqBuilderImpl> {
        private CreateMessageReqBuilderImpl() {
        }

        @Override
        protected CreateMessageReqBuilderImpl self() {
            return this;
        }

        @Override
        public CreateMessageReq build() {
            return new CreateMessageReq(this);
        }
    }

    public static abstract class CreateMessageReqBuilder<C extends CreateMessageReq, B extends CreateMessageReqBuilder<C, B>>
    extends BaseReq.BaseReqBuilder<C, B> {
        private String conversationID;
        private MessageRole role;
        private String content;
        private MessageContentType contentType;
        private Map<String, String> metadata;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="conversation_id")
        public B conversationID(@NonNull String conversationID) {
            if (conversationID == null) {
                throw new NullPointerException("conversationID is marked non-null but is null");
            }
            this.conversationID = conversationID;
            return (B)this.self();
        }

        public B role(@NonNull MessageRole role) {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            this.role = role;
            return (B)this.self();
        }

        public B content(String content) {
            this.content = content;
            return (B)this.self();
        }

        @JsonProperty(value="content_type")
        public B contentType(@NonNull MessageContentType contentType) {
            if (contentType == null) {
                throw new NullPointerException("contentType is marked non-null but is null");
            }
            this.contentType = contentType;
            return (B)this.self();
        }

        @JsonProperty(value="meta_data")
        public B metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CreateMessageReq.CreateMessageReqBuilder(super=" + super.toString() + ", conversationID=" + this.conversationID + ", role=" + this.role + ", content=" + this.content + ", contentType=" + this.contentType + ", metadata=" + this.metadata + ")";
        }
    }
}

