/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.websocket.common;

import com.coze.openapi.service.service.websocket.common.BaseCallbackHandler;
import com.coze.openapi.service.service.websocket.common.BaseWebsocketsClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class BaseWebsocketsListener
extends WebSocketListener {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final BiConsumer<WebSocket, String> handleEvent;
    private final BaseCallbackHandler callbackHandler;
    private final BaseWebsocketsClient client;

    public BaseWebsocketsListener(BiConsumer<WebSocket, String> handleEvent, BaseCallbackHandler handler, BaseWebsocketsClient client) {
        this.handleEvent = handleEvent;
        this.callbackHandler = handler;
        this.client = client;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        System.out.println("onOpen");
    }

    public void onMessage(WebSocket webSocket, String text) {
        this.executorService.submit(() -> this.handleEvent.accept(webSocket, text));
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.executorService.submit(() -> this.handleEvent.accept(webSocket, bytes.utf8()));
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.callbackHandler.onClosing(this.client, code, reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.callbackHandler.onFailure(this.client, new RuntimeException("websocket connection error: " + t.getMessage(), t));
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.callbackHandler.onClosed(this.client, code, reason);
    }

    public void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }
}

