/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.websocket.audio.speech;

import com.coze.openapi.client.websocket.event.downstream.ErrorEvent;
import com.coze.openapi.client.websocket.event.downstream.InputTextBufferCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.SpeechAudioCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.SpeechAudioUpdateEvent;
import com.coze.openapi.client.websocket.event.downstream.SpeechCreatedEvent;
import com.coze.openapi.client.websocket.event.downstream.SpeechUpdatedEvent;
import com.coze.openapi.client.websocket.event.model.SpeechUpdateEventData;
import com.coze.openapi.client.websocket.event.upstream.InputTextBufferAppendEvent;
import com.coze.openapi.client.websocket.event.upstream.InputTextBufferCompleteEvent;
import com.coze.openapi.client.websocket.event.upstream.SpeechUpdateEvent;
import com.coze.openapi.service.service.websocket.audio.speech.WebsocketsAudioSpeechCallbackHandler;
import com.coze.openapi.service.service.websocket.audio.speech.WebsocketsAudioSpeechCreateReq;
import com.coze.openapi.service.service.websocket.common.BaseCallbackHandler;
import com.coze.openapi.service.service.websocket.common.BaseWebsocketsClient;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;

public class WebsocketsAudioSpeechClient
extends BaseWebsocketsClient {
    private final WebsocketsAudioSpeechCallbackHandler handler;
    private static final String uri = "/v1/audio/speech";

    protected WebsocketsAudioSpeechClient(OkHttpClient client, String wsHost, WebsocketsAudioSpeechCreateReq req) {
        super(client, WebsocketsAudioSpeechClient.buildUrl(wsHost), req.getCallbackHandler(), req);
        this.handler = req.getCallbackHandler();
    }

    protected static String buildUrl(String wsHost) {
        return String.format("%s%s", wsHost, uri);
    }

    public void speechUpdate(SpeechUpdateEventData data) {
        this.sendEvent(((SpeechUpdateEvent.SpeechUpdateEventBuilder)SpeechUpdateEvent.builder().data(data)).build());
    }

    public void inputTextBufferAppend(String data) {
        this.sendEvent(InputTextBufferAppendEvent.of(data));
    }

    public void inputTextBufferComplete() {
        this.sendEvent(new InputTextBufferCompleteEvent());
    }

    @Override
    protected BaseCallbackHandler getCallbackHandler() {
        return this.handler;
    }

    @Override
    protected void handleEvent(WebSocket ws, String text) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(text);
            String eventType = this.parseEventType(jsonNode, text);
            if (eventType == null) {
                return;
            }
            switch (eventType) {
                case "speech.created": {
                    SpeechCreatedEvent speechCreatedEvent = (SpeechCreatedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, SpeechCreatedEvent.class);
                    this.handler.onSpeechCreated(this, speechCreatedEvent);
                    break;
                }
                case "speech.updated": {
                    SpeechUpdatedEvent speechUpdatedEvent = (SpeechUpdatedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, SpeechUpdatedEvent.class);
                    this.handler.onSpeechUpdated(this, speechUpdatedEvent);
                    break;
                }
                case "speech.audio.update": {
                    SpeechAudioUpdateEvent audioUpdateEvent = (SpeechAudioUpdateEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, SpeechAudioUpdateEvent.class);
                    this.handler.onSpeechAudioUpdate(this, audioUpdateEvent);
                    break;
                }
                case "speech.audio.completed": {
                    SpeechAudioCompletedEvent audioCompletedEvent = (SpeechAudioCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, SpeechAudioCompletedEvent.class);
                    this.handler.onSpeechAudioCompleted(this, audioCompletedEvent);
                    break;
                }
                case "input_text_buffer.completed": {
                    InputTextBufferCompletedEvent bufferCompletedEvent = (InputTextBufferCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, InputTextBufferCompletedEvent.class);
                    this.handler.onInputTextBufferCompleted(this, bufferCompletedEvent);
                    break;
                }
                case "error": {
                    ErrorEvent errorEvent = (ErrorEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ErrorEvent.class);
                    this.handler.onError(this, errorEvent);
                    break;
                }
                default: {
                    logger.error("unknown event type: {}, event string: {}", (Object)eventType, (Object)text);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handler.onClientException(this, new RuntimeException(e));
        }
    }
}

