/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.dataset;

import com.coze.openapi.api.DatasetImageAPI;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageNumBasedPaginator;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.client.dataset.image.ListImageReq;
import com.coze.openapi.client.dataset.image.ListImageResp;
import com.coze.openapi.client.dataset.image.UpdateImageReq;
import com.coze.openapi.client.dataset.image.UpdateImageResp;
import com.coze.openapi.client.dataset.image.model.Image;
import com.coze.openapi.service.utils.Utils;

public class ImageService {
    private final DatasetImageAPI api;

    public ImageService(DatasetImageAPI api) {
        this.api = api;
    }

    public UpdateImageResp update(UpdateImageReq req) {
        BaseResponse<UpdateImageResp> result = Utils.execute(this.api.update(req.getDatasetID(), req.getDocumentID(), req, req));
        return ((UpdateImageResp.UpdateImageRespBuilder)UpdateImageResp.builder().logID(result.getLogID())).build();
    }

    public PageResp<Image> list(ListImageReq req) {
        if (req.getDatasetID() == null) {
            throw new IllegalArgumentException("datasetID is required");
        }
        PageFetcher pageFetcher = request -> {
            ListImageResp resp = Utils.execute(this.api.list(req.getDatasetID(), req.getKeyword(), req.getHasCaption(), request.getPageNum(), request.getPageSize(), req)).getData();
            return PageResponse.builder().hasMore(resp.getImageInfos().size() == request.getPageSize().intValue()).data(resp.getImageInfos()).pageNum(request.getPageNum()).logID(resp.getLogID()).pageSize(request.getPageSize()).total(resp.getTotalCount()).build();
        };
        PageNumBasedPaginator paginator = new PageNumBasedPaginator(pageFetcher, req.getPageSize());
        PageRequest initialRequest = PageRequest.builder().pageNum(req.getPageNum()).pageSize(req.getPageSize()).build();
        PageResponse currentPage = pageFetcher.fetch(initialRequest);
        return PageResp.builder().total(currentPage.getTotal()).items(currentPage.getData()).iterator(paginator).hasMore(currentPage.isHasMore()).logID(currentPage.getLogID()).build();
    }
}

