/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.auth;

import com.coze.openapi.client.auth.LoadAuthConfig;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthConfig {
    @JsonProperty(value="client_type")
    private String clientType;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="client_secret")
    private String clientSecret;
    @JsonProperty(value="private_key")
    private String privateKey;
    @JsonProperty(value="public_key_id")
    private String publicKeyId;
    @JsonProperty(value="coze_api_base")
    private String cozeApiBase;
    @JsonProperty(value="coze_www_base")
    private String cozeWwwBase;

    public static OAuthConfig load(LoadAuthConfig config) {
        return OAuthConfig.doLoad(config.getFilePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OAuthConfig doLoad(String configFilePath) {
        try (FileInputStream inputStream = new FileInputStream(configFilePath);){
            ObjectMapper mapper = new ObjectMapper();
            mapper.findAndRegisterModules();
            OAuthConfig oAuthConfig = (OAuthConfig)mapper.readValue((InputStream)inputStream, OAuthConfig.class);
            return oAuthConfig;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Config file not found: " + configFilePath, e);
        }
        catch (StreamReadException e) {
            throw new RuntimeException("JSON file format error: " + e.getMessage(), e);
        }
        catch (DatabindException e) {
            throw new RuntimeException("Failed to map config file to object: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading config file: " + e.getMessage(), e);
        }
    }

    public static OAuthConfigBuilder builder() {
        return new OAuthConfigBuilder();
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    public String getCozeApiBase() {
        return this.cozeApiBase;
    }

    public String getCozeWwwBase() {
        return this.cozeWwwBase;
    }

    @JsonProperty(value="client_type")
    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    @JsonProperty(value="client_id")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty(value="client_secret")
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @JsonProperty(value="private_key")
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @JsonProperty(value="public_key_id")
    public void setPublicKeyId(String publicKeyId) {
        this.publicKeyId = publicKeyId;
    }

    @JsonProperty(value="coze_api_base")
    public void setCozeApiBase(String cozeApiBase) {
        this.cozeApiBase = cozeApiBase;
    }

    @JsonProperty(value="coze_www_base")
    public void setCozeWwwBase(String cozeWwwBase) {
        this.cozeWwwBase = cozeWwwBase;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthConfig)) {
            return false;
        }
        OAuthConfig other = (OAuthConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$publicKeyId = this.getPublicKeyId();
        String other$publicKeyId = other.getPublicKeyId();
        if (this$publicKeyId == null ? other$publicKeyId != null : !this$publicKeyId.equals(other$publicKeyId)) {
            return false;
        }
        String this$cozeApiBase = this.getCozeApiBase();
        String other$cozeApiBase = other.getCozeApiBase();
        if (this$cozeApiBase == null ? other$cozeApiBase != null : !this$cozeApiBase.equals(other$cozeApiBase)) {
            return false;
        }
        String this$cozeWwwBase = this.getCozeWwwBase();
        String other$cozeWwwBase = other.getCozeWwwBase();
        return !(this$cozeWwwBase == null ? other$cozeWwwBase != null : !this$cozeWwwBase.equals(other$cozeWwwBase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $publicKeyId = this.getPublicKeyId();
        result = result * 59 + ($publicKeyId == null ? 43 : $publicKeyId.hashCode());
        String $cozeApiBase = this.getCozeApiBase();
        result = result * 59 + ($cozeApiBase == null ? 43 : $cozeApiBase.hashCode());
        String $cozeWwwBase = this.getCozeWwwBase();
        result = result * 59 + ($cozeWwwBase == null ? 43 : $cozeWwwBase.hashCode());
        return result;
    }

    public String toString() {
        return "OAuthConfig(clientType=" + this.getClientType() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", privateKey=" + this.getPrivateKey() + ", publicKeyId=" + this.getPublicKeyId() + ", cozeApiBase=" + this.getCozeApiBase() + ", cozeWwwBase=" + this.getCozeWwwBase() + ")";
    }

    public OAuthConfig() {
    }

    public OAuthConfig(String clientType, String clientId, String clientSecret, String privateKey, String publicKeyId, String cozeApiBase, String cozeWwwBase) {
        this.clientType = clientType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.privateKey = privateKey;
        this.publicKeyId = publicKeyId;
        this.cozeApiBase = cozeApiBase;
        this.cozeWwwBase = cozeWwwBase;
    }

    public static class OAuthConfigBuilder {
        private String clientType;
        private String clientId;
        private String clientSecret;
        private String privateKey;
        private String publicKeyId;
        private String cozeApiBase;
        private String cozeWwwBase;

        OAuthConfigBuilder() {
        }

        @JsonProperty(value="client_type")
        public OAuthConfigBuilder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        @JsonProperty(value="client_id")
        public OAuthConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @JsonProperty(value="client_secret")
        public OAuthConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @JsonProperty(value="private_key")
        public OAuthConfigBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @JsonProperty(value="public_key_id")
        public OAuthConfigBuilder publicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this;
        }

        @JsonProperty(value="coze_api_base")
        public OAuthConfigBuilder cozeApiBase(String cozeApiBase) {
            this.cozeApiBase = cozeApiBase;
            return this;
        }

        @JsonProperty(value="coze_www_base")
        public OAuthConfigBuilder cozeWwwBase(String cozeWwwBase) {
            this.cozeWwwBase = cozeWwwBase;
            return this;
        }

        public OAuthConfig build() {
            return new OAuthConfig(this.clientType, this.clientId, this.clientSecret, this.privateKey, this.publicKeyId, this.cozeApiBase, this.cozeWwwBase);
        }

        public String toString() {
            return "OAuthConfig.OAuthConfigBuilder(clientType=" + this.clientType + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", privateKey=" + this.privateKey + ", publicKeyId=" + this.publicKeyId + ", cozeApiBase=" + this.cozeApiBase + ", cozeWwwBase=" + this.cozeWwwBase + ")";
        }
    }
}

