/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service;

import com.coze.openapi.api.AudioRoomAPI;
import com.coze.openapi.api.AudioSpeechAPI;
import com.coze.openapi.api.AudioVoiceAPI;
import com.coze.openapi.api.BotAPI;
import com.coze.openapi.api.ChatAPI;
import com.coze.openapi.api.ChatMessageAPI;
import com.coze.openapi.api.ConversationAPI;
import com.coze.openapi.api.ConversationMessageAPI;
import com.coze.openapi.api.DatasetAPI;
import com.coze.openapi.api.DatasetDocumentAPI;
import com.coze.openapi.api.DatasetImageAPI;
import com.coze.openapi.api.FileAPI;
import com.coze.openapi.api.TemplateAPI;
import com.coze.openapi.api.WorkflowChatAPI;
import com.coze.openapi.api.WorkflowRunAPI;
import com.coze.openapi.api.WorkflowRunHistoryAPI;
import com.coze.openapi.api.WorkspaceAPI;
import com.coze.openapi.service.auth.Auth;
import com.coze.openapi.service.service.APIResponseCallAdapterFactory;
import com.coze.openapi.service.service.AuthenticationInterceptor;
import com.coze.openapi.service.service.TimeoutInterceptor;
import com.coze.openapi.service.service.audio.AudioService;
import com.coze.openapi.service.service.bots.BotService;
import com.coze.openapi.service.service.chat.ChatService;
import com.coze.openapi.service.service.common.CozeLoggerFactory;
import com.coze.openapi.service.service.conversation.ConversationService;
import com.coze.openapi.service.service.dataset.DatasetService;
import com.coze.openapi.service.service.file.FileService;
import com.coze.openapi.service.service.template.TemplateService;
import com.coze.openapi.service.service.workflow.WorkflowService;
import com.coze.openapi.service.service.workspace.WorkspaceService;
import com.coze.openapi.service.utils.UserAgentInterceptor;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class CozeAPI {
    private static final Logger logger = CozeLoggerFactory.getLogger();
    private final String baseURL;
    private final ExecutorService executorService;
    private final Auth auth;
    private final WorkspaceService workspaceAPI;
    private final BotService botAPI;
    private final ConversationService conversationAPI;
    private final FileService fileAPI;
    private final DatasetService datasetAPI;
    private final WorkflowService workflowAPI;
    private final ChatService chatAPI;
    private final AudioService audioAPI;
    private final TemplateService templateAPI;

    private CozeAPI(String baseURL, ExecutorService executorService, Auth auth, WorkspaceService workspaceAPI, BotService botAPI, ConversationService conversationAPI, FileService fileAPI, DatasetService knowledgeAPI, WorkflowService workflowAPI, ChatService chatAPI, AudioService audioAPI, TemplateService templateAPI) {
        this.baseURL = baseURL;
        this.executorService = executorService;
        this.auth = auth;
        this.workspaceAPI = workspaceAPI;
        this.botAPI = botAPI;
        this.conversationAPI = conversationAPI;
        this.fileAPI = fileAPI;
        this.datasetAPI = knowledgeAPI;
        this.workflowAPI = workflowAPI;
        this.chatAPI = chatAPI;
        this.audioAPI = audioAPI;
        this.templateAPI = templateAPI;
    }

    public WorkspaceService workspaces() {
        return this.workspaceAPI;
    }

    public BotService bots() {
        return this.botAPI;
    }

    public ConversationService conversations() {
        return this.conversationAPI;
    }

    public FileService files() {
        return this.fileAPI;
    }

    public DatasetService datasets() {
        return this.datasetAPI;
    }

    public WorkflowService workflows() {
        return this.workflowAPI;
    }

    public ChatService chat() {
        return this.chatAPI;
    }

    public AudioService audio() {
        return this.audioAPI;
    }

    public TemplateService templates() {
        return this.templateAPI;
    }

    public void shutdownExecutor() {
        Objects.requireNonNull(this.executorService, "executorService must be set in order to shut down");
        this.executorService.shutdown();
    }

    public static class Builder {
        private String baseURL = "https://api.coze.com";
        private Auth auth;
        private OkHttpClient client;
        private int readTimeout = 5000;
        private int connectTimeout = 5000;

        public Builder logger(Logger logger) {
            CozeLoggerFactory.setLogger(logger);
            return this;
        }

        public Builder baseURL(String url) {
            this.baseURL = url;
            return this;
        }

        public Builder auth(Auth auth) {
            this.auth = auth;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public CozeAPI build() {
            if (this.auth == null) {
                throw new IllegalArgumentException("auth must be set");
            }
            this.client = this.client == null ? this.defaultClient(Duration.ofMillis(this.readTimeout), Duration.ofMillis(this.connectTimeout)) : this.parseClient(this.client);
            if (this.baseURL == null || this.baseURL.isEmpty()) {
                this.baseURL = "https://api.coze.com";
            }
            ObjectMapper mapper = Utils.defaultObjectMapper();
            Retrofit retrofit = this.defaultRetrofit(this.client, mapper, this.baseURL);
            ExecutorService executorService = this.client.dispatcher().executorService();
            WorkspaceService workspaceAPI = new WorkspaceService((WorkspaceAPI)retrofit.create(WorkspaceAPI.class));
            BotService botAPI = new BotService((BotAPI)retrofit.create(BotAPI.class));
            ConversationService conversationAPI = new ConversationService((ConversationAPI)retrofit.create(ConversationAPI.class), (ConversationMessageAPI)retrofit.create(ConversationMessageAPI.class));
            FileService fileAPI = new FileService((FileAPI)retrofit.create(FileAPI.class));
            DatasetService knowledgeAPI = new DatasetService((DatasetAPI)retrofit.create(DatasetAPI.class), (DatasetDocumentAPI)retrofit.create(DatasetDocumentAPI.class), (DatasetImageAPI)retrofit.create(DatasetImageAPI.class));
            WorkflowService workflowAPI = new WorkflowService((WorkflowRunAPI)retrofit.create(WorkflowRunAPI.class), (WorkflowRunHistoryAPI)retrofit.create(WorkflowRunHistoryAPI.class), (WorkflowChatAPI)retrofit.create(WorkflowChatAPI.class));
            ChatService chatAPI = new ChatService((ChatAPI)retrofit.create(ChatAPI.class), (ChatMessageAPI)retrofit.create(ChatMessageAPI.class));
            AudioService audioAPI = new AudioService((AudioVoiceAPI)retrofit.create(AudioVoiceAPI.class), (AudioRoomAPI)retrofit.create(AudioRoomAPI.class), (AudioSpeechAPI)retrofit.create(AudioSpeechAPI.class));
            TemplateService templateAPI = new TemplateService((TemplateAPI)retrofit.create(TemplateAPI.class));
            return new CozeAPI(this.baseURL, executorService, this.auth, workspaceAPI, botAPI, conversationAPI, fileAPI, knowledgeAPI, workflowAPI, chatAPI, audioAPI, templateAPI);
        }

        private OkHttpClient parseClient(OkHttpClient client) {
            boolean hasAuthInterceptor = false;
            boolean hasTimeoutInterceptor = false;
            boolean hasUserAgentInterceptor = false;
            for (Interceptor interceptor : client.interceptors()) {
                if (interceptor instanceof AuthenticationInterceptor) {
                    hasAuthInterceptor = true;
                }
                if (interceptor instanceof TimeoutInterceptor) {
                    hasTimeoutInterceptor = true;
                }
                if (!(interceptor instanceof UserAgentInterceptor)) continue;
                hasUserAgentInterceptor = true;
            }
            if (hasAuthInterceptor && hasTimeoutInterceptor && hasUserAgentInterceptor) {
                return client;
            }
            OkHttpClient.Builder builder = new OkHttpClient.Builder(client);
            if (!hasAuthInterceptor) {
                builder.addInterceptor((Interceptor)new AuthenticationInterceptor(this.auth));
            }
            if (!hasTimeoutInterceptor) {
                builder.addInterceptor((Interceptor)new TimeoutInterceptor());
            }
            if (!hasUserAgentInterceptor) {
                builder.addInterceptor((Interceptor)new UserAgentInterceptor());
            }
            return builder.build();
        }

        private OkHttpClient defaultClient(Duration readTimeout, Duration connectTimeout) {
            return new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(readTimeout.toMillis(), TimeUnit.MILLISECONDS).connectTimeout(connectTimeout.toMillis(), TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new AuthenticationInterceptor(this.auth)).addInterceptor((Interceptor)new TimeoutInterceptor()).addInterceptor((Interceptor)new UserAgentInterceptor()).build();
        }

        private Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper, String baseURL) {
            return new Retrofit.Builder().baseUrl(baseURL).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)APIResponseCallAdapterFactory.create()).build();
        }
    }
}

