/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.connversations.message.model;

import com.coze.openapi.client.connversations.message.model.MessageContentType;
import com.coze.openapi.client.connversations.message.model.MessageObjectString;
import com.coze.openapi.client.connversations.message.model.MessageRole;
import com.coze.openapi.client.connversations.message.model.MessageType;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class Message {
    @JsonProperty(value="role")
    private MessageRole role;
    @JsonProperty(value="type")
    private MessageType type;
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="content_type")
    private MessageContentType contentType;
    @JsonProperty(value="meta_data")
    private Map<String, String> metaData;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="conversation_id")
    private String conversationId;
    @JsonProperty(value="section_id")
    private String sectionId;
    @JsonProperty(value="bot_id")
    private String botId;
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="created_at")
    private Long createdAt;
    @JsonProperty(value="updated_at")
    private Long updatedAt;

    public static Message buildUserQuestionText(String content) {
        return Message.buildUserQuestionText(content, null);
    }

    public static Message buildUserQuestionText(String content, Map<String, String> metaData) {
        return Message.builder().role(MessageRole.USER).type(MessageType.QUESTION).content(content).contentType(MessageContentType.TEXT).metaData(metaData).build();
    }

    public static Message buildUserQuestionObjects(List<MessageObjectString> objects) {
        return Message.buildUserQuestionObjects(objects, null);
    }

    public static Message buildUserQuestionObjects(List<MessageObjectString> objects, Map<String, String> metaData) {
        return Message.builder().role(MessageRole.USER).type(MessageType.QUESTION).content(Utils.toJson(objects)).contentType(MessageContentType.OBJECT_STRING).metaData(metaData).build();
    }

    public static Message buildAssistantAnswer(String content) {
        return Message.buildAssistantAnswer(content, null);
    }

    public static Message buildAssistantAnswer(String content, Map<String, String> metaData) {
        return Message.builder().role(MessageRole.ASSISTANT).type(MessageType.ANSWER).content(content).contentType(MessageContentType.TEXT).metaData(metaData).build();
    }

    public static Message fromJson(String json) {
        return Utils.fromJson(json, Message.class);
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public MessageRole getRole() {
        return this.role;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public MessageContentType getContentType() {
        return this.contentType;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public String getId() {
        return this.id;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getBotId() {
        return this.botId;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="role")
    public void setRole(MessageRole role) {
        this.role = role;
    }

    @JsonProperty(value="type")
    public void setType(MessageType type) {
        this.type = type;
    }

    @JsonProperty(value="content")
    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="content_type")
    public void setContentType(MessageContentType contentType) {
        this.contentType = contentType;
    }

    @JsonProperty(value="meta_data")
    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="conversation_id")
    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    @JsonProperty(value="section_id")
    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    @JsonProperty(value="bot_id")
    public void setBotId(String botId) {
        this.botId = botId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Long this$updatedAt = this.getUpdatedAt();
        Long other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        MessageRole this$role = this.getRole();
        MessageRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        MessageType this$type = this.getType();
        MessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        MessageContentType this$contentType = this.getContentType();
        MessageContentType other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId)) {
            return false;
        }
        String this$sectionId = this.getSectionId();
        String other$sectionId = other.getSectionId();
        if (this$sectionId == null ? other$sectionId != null : !this$sectionId.equals(other$sectionId)) {
            return false;
        }
        String this$botId = this.getBotId();
        String other$botId = other.getBotId();
        if (this$botId == null ? other$botId != null : !this$botId.equals(other$botId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Long $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        MessageRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        MessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        MessageContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        String $sectionId = this.getSectionId();
        result = result * 59 + ($sectionId == null ? 43 : $sectionId.hashCode());
        String $botId = this.getBotId();
        result = result * 59 + ($botId == null ? 43 : $botId.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    public String toString() {
        return "Message(role=" + this.getRole() + ", type=" + this.getType() + ", content=" + this.getContent() + ", contentType=" + this.getContentType() + ", metaData=" + this.getMetaData() + ", id=" + this.getId() + ", conversationId=" + this.getConversationId() + ", sectionId=" + this.getSectionId() + ", botId=" + this.getBotId() + ", chatId=" + this.getChatId() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public Message() {
    }

    public Message(MessageRole role, MessageType type, String content, MessageContentType contentType, Map<String, String> metaData, String id, String conversationId, String sectionId, String botId, String chatId, Long createdAt, Long updatedAt) {
        this.role = role;
        this.type = type;
        this.content = content;
        this.contentType = contentType;
        this.metaData = metaData;
        this.id = id;
        this.conversationId = conversationId;
        this.sectionId = sectionId;
        this.botId = botId;
        this.chatId = chatId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public static class MessageBuilder {
        private MessageRole role;
        private MessageType type;
        private String content;
        private MessageContentType contentType;
        private Map<String, String> metaData;
        private String id;
        private String conversationId;
        private String sectionId;
        private String botId;
        private String chatId;
        private Long createdAt;
        private Long updatedAt;

        MessageBuilder() {
        }

        @JsonProperty(value="role")
        public MessageBuilder role(MessageRole role) {
            this.role = role;
            return this;
        }

        @JsonProperty(value="type")
        public MessageBuilder type(MessageType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="content")
        public MessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="content_type")
        public MessageBuilder contentType(MessageContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        @JsonProperty(value="meta_data")
        public MessageBuilder metaData(Map<String, String> metaData) {
            this.metaData = metaData;
            return this;
        }

        @JsonProperty(value="id")
        public MessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="conversation_id")
        public MessageBuilder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        @JsonProperty(value="section_id")
        public MessageBuilder sectionId(String sectionId) {
            this.sectionId = sectionId;
            return this;
        }

        @JsonProperty(value="bot_id")
        public MessageBuilder botId(String botId) {
            this.botId = botId;
            return this;
        }

        @JsonProperty(value="chat_id")
        public MessageBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="created_at")
        public MessageBuilder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="updated_at")
        public MessageBuilder updatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Message build() {
            return new Message(this.role, this.type, this.content, this.contentType, this.metaData, this.id, this.conversationId, this.sectionId, this.botId, this.chatId, this.createdAt, this.updatedAt);
        }

        public String toString() {
            return "Message.MessageBuilder(role=" + this.role + ", type=" + this.type + ", content=" + this.content + ", contentType=" + this.contentType + ", metaData=" + this.metaData + ", id=" + this.id + ", conversationId=" + this.conversationId + ", sectionId=" + this.sectionId + ", botId=" + this.botId + ", chatId=" + this.chatId + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

