/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.vector;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.vector.CoreVectorSearch;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.search.vector.VectorQuery;
import com.couchbase.client.java.search.vector.VectorSearchOptions;
import java.util.List;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class VectorSearch {
    private final List<VectorQuery> vectorQueries;
    @Nullable
    private final VectorSearchOptions vectorSearchOptions;

    private VectorSearch(List<VectorQuery> vectorQueries, @Nullable VectorSearchOptions vectorSearchOptions) {
        Validators.notNull(vectorQueries, (String)"VectorQueries");
        this.vectorQueries = vectorQueries;
        this.vectorSearchOptions = vectorSearchOptions;
    }

    public static VectorSearch create(List<VectorQuery> vectorQueries) {
        return new VectorSearch(vectorQueries, null);
    }

    public static VectorSearch create(List<VectorQuery> vectorQueries, VectorSearchOptions vectorSearchOptions) {
        return new VectorSearch(vectorQueries, vectorSearchOptions);
    }

    public static VectorSearch create(VectorQuery vectorQuery) {
        return new VectorSearch(CbCollections.listOf((Object[])new VectorQuery[]{vectorQuery}), null);
    }

    @Stability.Internal
    public CoreVectorSearch toCore() {
        return new CoreVectorSearch(this.vectorQueries.stream().map(VectorQuery::toCore).collect(Collectors.toList()), this.vectorSearchOptions == null ? null : this.vectorSearchOptions.build());
    }
}

