/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.query.AsyncCollectionQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;

@Stability.Volatile
public class CollectionQueryIndexManager {
    private final AsyncCollectionQueryIndexManager async;

    @Stability.Internal
    public CollectionQueryIndexManager(AsyncCollectionQueryIndexManager async) {
        this.async = async;
    }

    public void createPrimaryIndex() {
        AsyncUtils.block(this.async.createPrimaryIndex());
    }

    public void createPrimaryIndex(CreatePrimaryQueryIndexOptions options) {
        AsyncUtils.block(this.async.createPrimaryIndex(options));
    }

    public void createIndex(String indexName, Collection<String> fields) {
        AsyncUtils.block(this.async.createIndex(indexName, fields));
    }

    public void createIndex(String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        AsyncUtils.block(this.async.createIndex(indexName, fields, options));
    }

    public List<QueryIndex> getAllIndexes() {
        return AsyncUtils.block(this.async.getAllIndexes());
    }

    public List<QueryIndex> getAllIndexes(GetAllQueryIndexesOptions options) {
        return AsyncUtils.block(this.async.getAllIndexes(options));
    }

    public void dropPrimaryIndex() {
        AsyncUtils.block(this.async.dropPrimaryIndex());
    }

    public void dropPrimaryIndex(DropPrimaryQueryIndexOptions options) {
        AsyncUtils.block(this.async.dropPrimaryIndex(options));
    }

    public void dropIndex(String indexName) {
        AsyncUtils.block(this.async.dropIndex(indexName));
    }

    public void dropIndex(String indexName, DropQueryIndexOptions options) {
        AsyncUtils.block(this.async.dropIndex(indexName, options));
    }

    public void buildDeferredIndexes() {
        AsyncUtils.block(this.async.buildDeferredIndexes());
    }

    public void buildDeferredIndexes(BuildQueryIndexOptions options) {
        AsyncUtils.block(this.async.buildDeferredIndexes(options));
    }

    public void watchIndexes(Collection<String> indexNames, Duration timeout) {
        AsyncUtils.block(this.async.watchIndexes(indexNames, timeout));
    }

    public void watchIndexes(Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        AsyncUtils.block(this.async.watchIndexes(indexNames, timeout, options));
    }
}

