/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreBuildQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreCreatePrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreCreateQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreDropPrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreDropQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreGetAllQueryIndexesOptions;
import com.couchbase.client.core.api.manager.CoreQueryIndex;
import com.couchbase.client.core.api.manager.CoreWatchQueryIndexesOptions;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.manager.CoreQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AsyncQueryIndexManager {
    private final CoreQueryIndexManager internal;

    @Stability.Internal
    public AsyncQueryIndexManager(CoreQueryOps queryOps, RequestTracer requestTracer) {
        this.internal = new CoreQueryIndexManager(queryOps, requestTracer);
    }

    public CompletableFuture<Void> createIndex(String bucketName, String indexName, Collection<String> fields) {
        return this.createIndex(bucketName, indexName, fields, CreateQueryIndexOptions.createQueryIndexOptions());
    }

    public CompletableFuture<Void> createIndex(String bucketName, String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        return this.internal.createIndex(bucketName, indexName, fields, (CoreCreateQueryIndexOptions)options.build());
    }

    public CompletableFuture<Void> createPrimaryIndex(String bucketName) {
        return this.createPrimaryIndex(bucketName, CreatePrimaryQueryIndexOptions.createPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> createPrimaryIndex(String bucketName, CreatePrimaryQueryIndexOptions options) {
        return this.internal.createPrimaryIndex(bucketName, (CoreCreatePrimaryQueryIndexOptions)options.build());
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes(String bucketName) {
        return this.getAllIndexes(bucketName, GetAllQueryIndexesOptions.getAllQueryIndexesOptions());
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes(String bucketName, GetAllQueryIndexesOptions options) {
        return this.internal.getAllIndexes(bucketName, (CoreGetAllQueryIndexesOptions)options.build()).thenApply(rows -> rows.stream().map(row -> new QueryIndex((CoreQueryIndex)row)).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropPrimaryIndex(String bucketName) {
        return this.dropPrimaryIndex(bucketName, DropPrimaryQueryIndexOptions.dropPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> dropPrimaryIndex(String bucketName, DropPrimaryQueryIndexOptions options) {
        return this.internal.dropPrimaryIndex(bucketName, (CoreDropPrimaryQueryIndexOptions)options.build());
    }

    public CompletableFuture<Void> dropIndex(String bucketName, String indexName) {
        return this.dropIndex(bucketName, indexName, DropQueryIndexOptions.dropQueryIndexOptions());
    }

    public CompletableFuture<Void> dropIndex(String bucketName, String indexName, DropQueryIndexOptions options) {
        return this.internal.dropIndex(bucketName, indexName, (CoreDropQueryIndexOptions)options.build());
    }

    public CompletableFuture<Void> buildDeferredIndexes(String bucketName) {
        return this.buildDeferredIndexes(bucketName, BuildQueryIndexOptions.buildDeferredQueryIndexesOptions());
    }

    public CompletableFuture<Void> buildDeferredIndexes(String bucketName, BuildQueryIndexOptions options) {
        return this.internal.buildDeferredIndexes(bucketName, (CoreBuildQueryIndexOptions)options.build());
    }

    public CompletableFuture<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout) {
        return this.watchIndexes(bucketName, indexNames, timeout, WatchQueryIndexesOptions.watchQueryIndexesOptions());
    }

    public CompletableFuture<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        return this.internal.watchIndexes(bucketName, indexNames, timeout, (CoreWatchQueryIndexesOptions)options.build());
    }
}

