/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.manager.CoreBucketManagerOps;
import com.couchbase.client.core.manager.bucket.CoreConflictResolutionType;
import com.couchbase.client.core.manager.bucket.CoreCreateBucketSettings;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncBucketManager {
    private final CoreBucketManagerOps coreBucketManager;

    @Stability.Internal
    public AsyncBucketManager(CoreCouchbaseOps ops) {
        this.coreBucketManager = ops.bucketManager();
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings) {
        return this.createBucket(settings, CreateBucketOptions.createBucketOptions());
    }

    public CompletableFuture<Void> createBucket(final BucketSettings settings, CreateBucketOptions options) {
        return this.coreBucketManager.createBucket(settings.toCore(), new CoreCreateBucketSettings(){

            public CoreConflictResolutionType conflictResolutionType() {
                if (settings.conflictResolutionType() == null) {
                    return null;
                }
                switch (settings.conflictResolutionType()) {
                    case TIMESTAMP: {
                        return CoreConflictResolutionType.TIMESTAMP;
                    }
                    case SEQUENCE_NUMBER: {
                        return CoreConflictResolutionType.SEQUENCE_NUMBER;
                    }
                    case CUSTOM: {
                        return CoreConflictResolutionType.CUSTOM;
                    }
                }
                throw new CouchbaseException("Unknown conflict resolution type");
            }
        }, (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings) {
        return this.updateBucket(settings, UpdateBucketOptions.updateBucketOptions());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        return this.coreBucketManager.updateBucket(settings.toCore(), (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> dropBucket(String bucketName) {
        return this.dropBucket(bucketName, DropBucketOptions.dropBucketOptions());
    }

    public CompletableFuture<Void> dropBucket(String bucketName, DropBucketOptions options) {
        return this.coreBucketManager.dropBucket(bucketName, (CoreCommonOptions)options.build());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName) {
        return this.getBucket(bucketName, GetBucketOptions.getBucketOptions());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName, GetBucketOptions options) {
        return this.coreBucketManager.getBucket(bucketName, (CoreCommonOptions)options.build()).thenApply(BucketSettings::new);
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets() {
        return this.getAllBuckets(GetAllBucketOptions.getAllBucketOptions());
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets(GetAllBucketOptions options) {
        return this.coreBucketManager.getAllBuckets((CoreCommonOptions)options.build()).thenApply(buckets -> CbCollections.transformValues((Map)buckets, BucketSettings::new));
    }

    public CompletableFuture<Void> flushBucket(String bucketName) {
        return this.flushBucket(bucketName, FlushBucketOptions.flushBucketOptions());
    }

    public CompletableFuture<Void> flushBucket(String bucketName, FlushBucketOptions options) {
        return this.coreBucketManager.flushBucket(bucketName, (CoreCommonOptions)options.build());
    }
}

