/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.kv.AppendOptions;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DecrementOptions;
import com.couchbase.client.java.kv.IncrementOptions;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PrependOptions;

public class BinaryCollection {
    static final AppendOptions DEFAULT_APPEND_OPTIONS = AppendOptions.appendOptions();
    static final PrependOptions DEFAULT_PREPEND_OPTIONS = PrependOptions.prependOptions();
    static final IncrementOptions DEFAULT_INCREMENT_OPTIONS = IncrementOptions.incrementOptions();
    static final DecrementOptions DEFAULT_DECREMENT_OPTIONS = DecrementOptions.decrementOptions();
    private final CollectionIdentifier collectionIdentifier;
    private final CoreKvBinaryOps coreKvBinaryOps;

    BinaryCollection(AsyncBinaryCollection asyncBinaryCollection) {
        this.collectionIdentifier = asyncBinaryCollection.collectionIdentifier();
        this.coreKvBinaryOps = asyncBinaryCollection.coreKvBinaryOps;
    }

    public MutationResult append(String id, byte[] content) {
        return this.append(id, content, DEFAULT_APPEND_OPTIONS);
    }

    public MutationResult append(String id, byte[] content, AppendOptions options) {
        AppendOptions.Built opts = ((AppendOptions)Validators.notNull((Object)options, (String)"AppendOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return new MutationResult(this.coreKvBinaryOps.appendBlocking(id, content, (CoreCommonOptions)opts, opts.cas(), opts.toCoreDurability()));
    }

    public MutationResult prepend(String id, byte[] content) {
        return this.prepend(id, content, DEFAULT_PREPEND_OPTIONS);
    }

    public MutationResult prepend(String id, byte[] content, PrependOptions options) {
        PrependOptions.Built opts = ((PrependOptions)Validators.notNull((Object)options, (String)"PrependOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return new MutationResult(this.coreKvBinaryOps.prependBlocking(id, content, (CoreCommonOptions)opts, opts.cas(), opts.toCoreDurability()));
    }

    public CounterResult increment(String id) {
        return this.increment(id, DEFAULT_INCREMENT_OPTIONS);
    }

    public CounterResult increment(String id, IncrementOptions options) {
        IncrementOptions.Built opts = ((IncrementOptions)Validators.notNull((Object)options, (String)"IncrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return new CounterResult(this.coreKvBinaryOps.incrementBlocking(id, (CoreCommonOptions)opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()));
    }

    public CounterResult decrement(String id) {
        return this.decrement(id, DEFAULT_DECREMENT_OPTIONS);
    }

    public CounterResult decrement(String id, DecrementOptions options) {
        DecrementOptions.Built opts = ((DecrementOptions)Validators.notNull((Object)options, (String)"DecrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return new CounterResult(this.coreKvBinaryOps.decrementBlocking(id, (CoreCommonOptions)opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()));
    }
}

