/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreCoordinate;
import com.couchbase.client.core.api.search.queries.CoreGeoPolygonQuery;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.util.Coordinate;
import java.util.List;
import java.util.stream.Collectors;

public class GeoPolygonQuery
extends SearchQuery {
    private final List<Coordinate> coordinates;
    private String field;

    public GeoPolygonQuery(List<Coordinate> coordinates) {
        this.coordinates = Validators.notNullOrEmpty(coordinates, (String)"GeoPolygonQuery Coordinates");
    }

    public GeoPolygonQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public GeoPolygonQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    public CoreSearchQuery toCore() {
        return new CoreGeoPolygonQuery(this.coordinates.stream().map(v -> new CoreCoordinate(v.lon(), v.lat())).collect(Collectors.toList()), this.field, this.boost);
    }
}

