/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreCreateQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.HashMap;
import java.util.Map;

public class CreateQueryIndexOptions
extends CommonOptions<CreateQueryIndexOptions> {
    private final Map<String, Object> with = new HashMap<String, Object>();
    private boolean ignoreIfExists;
    private String scopeName;
    private String collectionName;

    private CreateQueryIndexOptions() {
    }

    public static CreateQueryIndexOptions createQueryIndexOptions() {
        return new CreateQueryIndexOptions();
    }

    public CreateQueryIndexOptions ignoreIfExists(boolean ignoreIfExists) {
        this.ignoreIfExists = ignoreIfExists;
        return this;
    }

    public CreateQueryIndexOptions numReplicas(int numReplicas) {
        if (numReplicas < 0) {
            throw InvalidArgumentException.fromMessage((String)"numReplicas must be >= 0");
        }
        return this.with("num_replica", numReplicas);
    }

    public CreateQueryIndexOptions deferred(boolean deferred) {
        return this.with("defer_build", deferred);
    }

    public CreateQueryIndexOptions with(String optionName, Object optionValue) {
        this.with.put(Validators.notNullOrEmpty((String)optionName, (String)"OptionName"), Validators.notNull((Object)optionValue, (String)"OptionValue"));
        return this;
    }

    @Deprecated
    public CreateQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty((String)scopeName, (String)"ScopeName");
        return this;
    }

    @Deprecated
    public CreateQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty((String)collectionName, (String)"CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreCreateQueryIndexOptions {
        Built() {
            super(CreateQueryIndexOptions.this);
        }

        public boolean ignoreIfExists() {
            return CreateQueryIndexOptions.this.ignoreIfExists;
        }

        public Map<String, Object> with() {
            return CreateQueryIndexOptions.this.with;
        }

        public CoreScopeAndCollection scopeAndCollection() {
            if (CreateQueryIndexOptions.this.scopeName != null && CreateQueryIndexOptions.this.collectionName != null) {
                return new CoreScopeAndCollection(CreateQueryIndexOptions.this.scopeName, CreateQueryIndexOptions.this.collectionName);
            }
            return null;
        }

        public CoreCommonOptions commonOptions() {
            return this;
        }
    }
}

