/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.kv.RangeScan;
import com.couchbase.client.java.kv.SamplingScan;
import com.couchbase.client.java.kv.ScanTerm;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

@Stability.Volatile
public abstract class ScanType {
    public static RangeScan rangeScan() {
        return ScanType.rangeScan(ScanTerm.minimum(), ScanTerm.maximum());
    }

    public static RangeScan rangeScan(ScanTerm from, ScanTerm to) {
        return new RangeScan(from, to);
    }

    public static RangeScan prefixScan(String documentIdPrefix) {
        return new RangeScan(ScanTerm.inclusive(documentIdPrefix), ScanTerm.exclusive(ScanType.concat(documentIdPrefix.getBytes(StandardCharsets.UTF_8), (byte)-1)));
    }

    private static byte[] concat(byte[] first, byte second) {
        byte[] result = new byte[first.length + 1];
        System.arraycopy(first, 0, result, 0, first.length);
        result[first.length] = second;
        return result;
    }

    public static SamplingScan samplingScan(long limit) {
        return new SamplingScan(limit, Optional.empty());
    }

    public static SamplingScan samplingScan(long limit, long seed) {
        return new SamplingScan(limit, Optional.of(seed));
    }
}

