/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.internal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import java.io.IOException;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class OptionsUtil {
    private OptionsUtil() {
    }

    public static ObjectNode createTransactionOptions(@Nullable ReactiveScope scope, String statement, @Nullable TransactionQueryOptions options) {
        JsonObject json = JsonObject.create().put("statement", statement);
        if (scope != null) {
            json.put("query_context", QueryRequest.queryContext((String)scope.bucketName(), (String)scope.name()));
        }
        if (options != null) {
            options.builder().build().injectParams(json);
        }
        try {
            return (ObjectNode)Mapper.reader().readValue(json.toBytes(), ObjectNode.class);
        }
        catch (IOException e) {
            throw new EncodingFailureException((Throwable)e);
        }
    }
}

