/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.json;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonGenerator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonParser;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonToken;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.Version;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationContext;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonDeserializer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonSerializer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.SerializerProvider;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.module.SimpleModule;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.io.IOException;

@Stability.Internal
public class RepackagedJsonValueModule
extends SimpleModule {
    private final boolean decimalForFloat = Boolean.parseBoolean(System.getProperty("com.couchbase.json.decimalForFloat", "false"));

    public RepackagedJsonValueModule() {
        super(new Version(1, 0, 0, null, "com.couchbase", "JsonValueModule"));
        this.addSerializer(JsonObject.class, new JsonObjectSerializer());
        this.addDeserializer(JsonObject.class, new JsonObjectDeserializer());
        this.addSerializer(JsonArray.class, new JsonArraySerializer());
        this.addDeserializer(JsonArray.class, new JsonArrayDeserializer());
    }

    private static void expectCurrentToken(JsonParser parser, JsonToken expected) throws IOException {
        if (RepackagedJsonValueModule.currentToken(parser) != expected) {
            throw new IOException("Expected " + expected + " but got " + RepackagedJsonValueModule.currentToken(parser));
        }
    }

    private static JsonToken currentToken(JsonParser parser) {
        return parser.getCurrentToken();
    }

    static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        JsonObjectSerializer() {
        }

        public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.toMap());
        }
    }

    class JsonObjectDeserializer
    extends AbstractJsonValueDeserializer<JsonObject> {
        JsonObjectDeserializer() {
        }

        public JsonObject deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
            return this.decodeObject(jp);
        }
    }

    static class JsonArraySerializer
    extends JsonSerializer<JsonArray> {
        JsonArraySerializer() {
        }

        public void serialize(JsonArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.toList());
        }
    }

    class JsonArrayDeserializer
    extends AbstractJsonValueDeserializer<JsonArray> {
        JsonArrayDeserializer() {
        }

        public JsonArray deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
            return this.decodeArray(jp);
        }
    }

    abstract class AbstractJsonValueDeserializer<T>
    extends JsonDeserializer<T> {
        AbstractJsonValueDeserializer() {
        }

        JsonObject decodeObject(JsonParser parser) throws IOException {
            RepackagedJsonValueModule.expectCurrentToken(parser, JsonToken.START_OBJECT);
            JsonObject result = JsonObject.create();
            JsonToken current;
            while ((current = parser.nextToken()) != JsonToken.END_OBJECT) {
                RepackagedJsonValueModule.expectCurrentToken(parser, JsonToken.FIELD_NAME);
                parser.nextToken();
                result.put(parser.getCurrentName(), this.decodeValue(parser));
            }
            return result;
        }

        JsonArray decodeArray(JsonParser parser) throws IOException {
            RepackagedJsonValueModule.expectCurrentToken(parser, JsonToken.START_ARRAY);
            JsonArray result = JsonArray.create();
            JsonToken current;
            while ((current = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(this.decodeValue(parser));
            }
            return result;
        }

        Object decodeValue(JsonParser parser) throws IOException {
            JsonToken current = RepackagedJsonValueModule.currentToken(parser);
            switch (current) {
                case START_OBJECT: {
                    return this.decodeObject(parser);
                }
                case START_ARRAY: {
                    return this.decodeArray(parser);
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return parser.getBooleanValue();
                }
                case VALUE_STRING: {
                    return parser.getValueAsString();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    Number numberValue = parser.getNumberValue();
                    if (numberValue instanceof Double && RepackagedJsonValueModule.this.decimalForFloat) {
                        numberValue = parser.getDecimalValue();
                    }
                    return numberValue;
                }
                case VALUE_NULL: {
                    return null;
                }
            }
            throw new IOException("Unexpected JSON token: " + current);
        }
    }
}

