/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.IndexesNotReadyException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.QueryException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class AsyncQueryIndexManager {
    private final AsyncCluster cluster;
    private static final Map<Predicate<QueryException>, Function<QueryException, ? extends QueryException>> errorMessageMap = new LinkedHashMap<Predicate<QueryException>, Function<QueryException, ? extends QueryException>>();

    @Stability.Internal
    public AsyncQueryIndexManager(AsyncCluster cluster) {
        this.cluster = Objects.requireNonNull(cluster);
    }

    public CompletableFuture<Void> createIndex(String bucketName, String indexName, Collection<String> fields) {
        return this.createIndex(bucketName, indexName, fields, CreateQueryIndexOptions.createQueryIndexOptions());
    }

    public CompletableFuture<Void> createIndex(String bucketName, String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNullOrEmpty((String)indexName, (String)"IndexName");
        Validators.notNullOrEmpty(fields, (String)"Fields");
        Validators.notNull((Object)options, (String)"Options");
        CreateQueryIndexOptions.Built builtOpts = options.build();
        String keyspace = AsyncQueryIndexManager.buildKeyspace(bucketName, builtOpts.scopeName(), builtOpts.collectionName());
        String statement = "CREATE INDEX " + AsyncQueryIndexManager.quote(indexName) + " ON " + keyspace + AsyncQueryIndexManager.formatIndexFields(fields);
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts.with(), builtOpts, "manager_query_create_index", bucketName, null).exceptionally(t -> {
            if (builtOpts.ignoreIfExists() && CbThrowables.hasCause((Throwable)t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> createPrimaryIndex(String bucketName) {
        return this.createPrimaryIndex(bucketName, CreatePrimaryQueryIndexOptions.createPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> createPrimaryIndex(String bucketName, CreatePrimaryQueryIndexOptions options) {
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNull((Object)options, (String)"Options");
        CreatePrimaryQueryIndexOptions.Built builtOpts = options.build();
        String indexName = builtOpts.indexName().orElse(null);
        String keyspace = AsyncQueryIndexManager.buildKeyspace(bucketName, builtOpts.scopeName(), builtOpts.collectionName());
        String statement = "CREATE PRIMARY INDEX ";
        if (indexName != null) {
            statement = statement + AsyncQueryIndexManager.quote(indexName) + " ";
        }
        statement = statement + "ON " + keyspace;
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts.with(), builtOpts, "manager_query_create_primary_index", bucketName, null).exceptionally(t -> {
            if (builtOpts.ignoreIfExists() && CbThrowables.hasCause((Throwable)t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes(String bucketName) {
        return this.getAllIndexes(bucketName, GetAllQueryIndexesOptions.getAllQueryIndexesOptions());
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes(String bucketName, GetAllQueryIndexesOptions options) {
        JsonArray params;
        String statement;
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNull((Object)options, (String)"Options");
        GetAllQueryIndexesOptions.Built builtOpts = options.build();
        if (builtOpts.scopeName().isPresent() && builtOpts.collectionName().isPresent()) {
            statement = "SELECT idx.* FROM system:indexes AS idx WHERE keyspace_id = ? AND bucket_id = ? AND scope_id = ? AND `using` = \"gsi\" ORDER BY is_primary DESC, name ASC";
            params = JsonArray.from(builtOpts.collectionName().get(), bucketName, builtOpts.scopeName().get());
        } else if (builtOpts.scopeName().isPresent()) {
            statement = "SELECT idx.* FROM system:indexes AS idx WHERE bucket_id = ? AND scope_id = ? AND `using` = \"gsi\" ORDER BY is_primary DESC, name ASC";
            params = JsonArray.from(bucketName, builtOpts.scopeName().get());
        } else {
            statement = "SELECT idx.* FROM system:indexes AS idx WHERE ((bucket_id IS MISSING AND keyspace_id = ?) OR bucket_id = ?) AND `using` = \"gsi\" ORDER BY is_primary DESC, name ASC";
            params = JsonArray.from(bucketName, bucketName);
        }
        return this.exec(QueryType.READ_ONLY, statement, builtOpts, "manager_query_get_all_indexes", bucketName, params).thenApply(result -> result.rowsAsObject().stream().map(QueryIndex::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropPrimaryIndex(String bucketName) {
        return this.dropPrimaryIndex(bucketName, DropPrimaryQueryIndexOptions.dropPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> dropPrimaryIndex(String bucketName, DropPrimaryQueryIndexOptions options) {
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNull((Object)options, (String)"Options");
        DropPrimaryQueryIndexOptions.Built builtOpts = options.build();
        String keyspace = AsyncQueryIndexManager.buildKeyspace(bucketName, builtOpts.scopeName(), builtOpts.collectionName());
        String statement = "DROP PRIMARY INDEX ON " + keyspace;
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts, "manager_query_drop_primary_index", bucketName, null).exceptionally(t -> {
            if (builtOpts.ignoreIfNotExists() && CbThrowables.hasCause((Throwable)t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> dropIndex(String bucketName, String indexName) {
        return this.dropIndex(bucketName, indexName, DropQueryIndexOptions.dropQueryIndexOptions());
    }

    public CompletableFuture<Void> dropIndex(String bucketName, String indexName, DropQueryIndexOptions options) {
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNullOrEmpty((String)indexName, (String)"IndexName");
        Validators.notNull((Object)options, (String)"Options");
        DropQueryIndexOptions.Built builtOpts = options.build();
        String statement = builtOpts.scopeName().isPresent() && builtOpts.collectionName().isPresent() ? "DROP INDEX " + AsyncQueryIndexManager.quote(indexName) + " ON " + AsyncQueryIndexManager.buildKeyspace(bucketName, builtOpts.scopeName(), builtOpts.collectionName()) : "DROP INDEX " + AsyncQueryIndexManager.quote(bucketName, indexName);
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts, "manager_query_drop_index", bucketName, null).exceptionally(t -> {
            if (builtOpts.ignoreIfNotExists() && CbThrowables.hasCause((Throwable)t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> buildDeferredIndexes(String bucketName) {
        return this.buildDeferredIndexes(bucketName, BuildQueryIndexOptions.buildDeferredQueryIndexesOptions());
    }

    public CompletableFuture<Void> buildDeferredIndexes(String bucketName, BuildQueryIndexOptions options) {
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNull((Object)options, (String)"Options");
        BuildQueryIndexOptions.Built builtOpts = options.build();
        GetAllQueryIndexesOptions getAllOptions = GetAllQueryIndexesOptions.getAllQueryIndexesOptions();
        builtOpts.collectionName().ifPresent(getAllOptions::collectionName);
        builtOpts.scopeName().ifPresent(getAllOptions::scopeName);
        builtOpts.timeout().ifPresent(getAllOptions::timeout);
        return Reactor.toMono(() -> this.getAllIndexes(bucketName, getAllOptions)).map(indexes -> indexes.stream().filter(idx -> idx.state().equals("deferred")).map(idx -> AsyncQueryIndexManager.quote(idx.name())).collect(Collectors.toList())).flatMap(indexNames -> {
            if (indexNames.isEmpty()) {
                return Mono.empty();
            }
            String keyspace = builtOpts.collectionName().isPresent() && builtOpts.scopeName().isPresent() ? AsyncQueryIndexManager.buildKeyspace(bucketName, builtOpts.scopeName(), builtOpts.collectionName()) : AsyncQueryIndexManager.quote(bucketName);
            String statement = "BUILD INDEX ON " + keyspace + " (" + String.join((CharSequence)",", indexNames) + ")";
            return Reactor.toMono(() -> this.exec(QueryType.WRITE, statement, builtOpts, "manager_query_build_deferred_indexes", bucketName, null).thenApply(result -> null));
        }).then().toFuture();
    }

    public CompletableFuture<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout) {
        return this.watchIndexes(bucketName, indexNames, timeout, WatchQueryIndexesOptions.watchQueryIndexesOptions());
    }

    public CompletableFuture<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNull(indexNames, (String)"IndexNames");
        Validators.notNull((Object)timeout, (String)"Timeout");
        Validators.notNull((Object)options, (String)"Options");
        HashSet<String> indexNameSet = new HashSet<String>(indexNames);
        WatchQueryIndexesOptions.Built builtOpts = options.build();
        RequestSpan parent = this.cluster.environment().requestTracer().requestSpan("manager_query_watch_indexes", null);
        parent.attribute("db.system", "couchbase");
        return Mono.fromFuture(() -> this.failIfIndexesOffline(bucketName, indexNameSet, builtOpts.watchPrimary(), parent, builtOpts.scopeName(), builtOpts.collectionName())).retryWhen(Retry.onlyIf(ctx -> CbThrowables.hasCause((Throwable)ctx.exception(), IndexesNotReadyException.class)).exponentialBackoff(Duration.ofMillis(50L), Duration.ofSeconds(1L)).timeout(timeout).toReactorRetry()).onErrorMap(t -> t instanceof RetryExhaustedException ? AsyncQueryIndexManager.toWatchTimeoutException(t, timeout) : t).toFuture().whenComplete((r, t) -> parent.end());
    }

    private static String formatIndexFields(Collection<String> fields) {
        return "(" + String.join((CharSequence)",", fields) + ")";
    }

    private static TimeoutException toWatchTimeoutException(Throwable t, Duration timeout) {
        StringBuilder msg = new StringBuilder("A requested index is still not ready after " + timeout + ".");
        CbThrowables.findCause((Throwable)t, IndexesNotReadyException.class).ifPresent(cause -> msg.append(" Unready index name -> state: ").append(RedactableArgument.redactMeta((Object)cause.indexNameToState())));
        return new TimeoutException(msg.toString());
    }

    private CompletableFuture<Void> failIfIndexesOffline(String bucketName, Set<String> indexNames, boolean includePrimary, RequestSpan parentSpan, Optional<String> scopeName, Optional<String> collectionName) throws IndexesNotReadyException, IndexNotFoundException {
        Objects.requireNonNull(bucketName);
        Objects.requireNonNull(indexNames);
        GetAllQueryIndexesOptions getAllQueryIndexesOptions = (GetAllQueryIndexesOptions)GetAllQueryIndexesOptions.getAllQueryIndexesOptions().parentSpan(parentSpan);
        scopeName.ifPresent(getAllQueryIndexesOptions::scopeName);
        collectionName.ifPresent(getAllQueryIndexesOptions::collectionName);
        return this.getAllIndexes(bucketName, getAllQueryIndexesOptions).thenApply(allIndexes -> {
            List matchingIndexes = allIndexes.stream().filter(idx -> indexNames.contains(idx.name()) || includePrimary && idx.primary()).collect(Collectors.toList());
            boolean primaryIndexPresent = matchingIndexes.stream().anyMatch(QueryIndex::primary);
            if (includePrimary && !primaryIndexPresent) {
                throw new IndexNotFoundException("#primary");
            }
            Set matchingIndexNames = matchingIndexes.stream().map(QueryIndex::name).collect(Collectors.toSet());
            Set missingIndexNames = AsyncQueryIndexManager.difference(indexNames, matchingIndexNames);
            if (!missingIndexNames.isEmpty()) {
                throw new IndexNotFoundException(missingIndexNames.toString());
            }
            Map<String, String> offlineIndexNameToState = matchingIndexes.stream().filter(idx -> !"online".equals(idx.state())).collect(Collectors.toMap(QueryIndex::name, QueryIndex::state));
            if (!offlineIndexNameToState.isEmpty()) {
                throw new IndexesNotReadyException(offlineIndexNameToState);
            }
            return null;
        });
    }

    private static <T> Set<T> difference(Set<T> lhs, Set<T> rhs) {
        HashSet<T> result = new HashSet<T>(lhs);
        result.removeAll(rhs);
        return result;
    }

    private CompletableFuture<QueryResult> exec(QueryType queryType, CharSequence statement, Map<String, Object> with, CommonOptions.BuiltCommonOptions options, String spanName, String bucketName, JsonArray parameters) {
        return with.isEmpty() ? this.exec(queryType, statement, options, spanName, bucketName, parameters) : this.exec(queryType, statement + " WITH " + Mapper.encodeAsString(with), options, spanName, bucketName, parameters);
    }

    private CompletableFuture<QueryResult> exec(QueryType queryType, CharSequence statement, CommonOptions.BuiltCommonOptions options, String spanName, String bucketName, JsonArray parameters) {
        QueryOptions queryOpts = AsyncQueryIndexManager.toQueryOptions(options).readonly(Objects.requireNonNull(queryType) == QueryType.READ_ONLY);
        if (parameters != null && !parameters.isEmpty()) {
            queryOpts.parameters(parameters);
        }
        RequestSpan parent = this.cluster.environment().requestTracer().requestSpan(spanName, (RequestSpan)options.parentSpan().orElse(null));
        parent.attribute("db.system", "couchbase");
        if (bucketName != null) {
            parent.attribute("db.name", bucketName);
        }
        queryOpts.parentSpan(parent);
        return ((CompletableFuture)this.cluster.query(statement.toString(), queryOpts).exceptionally(t -> {
            throw this.translateException((Throwable)t);
        })).whenComplete((r, t) -> parent.end());
    }

    private static QueryOptions toQueryOptions(CommonOptions.BuiltCommonOptions options) {
        QueryOptions result = QueryOptions.queryOptions();
        options.timeout().ifPresent(result::timeout);
        options.retryStrategy().ifPresent(result::retryStrategy);
        result.clientContext(options.clientContext());
        return result;
    }

    private RuntimeException translateException(Throwable t) {
        if (t instanceof QueryException) {
            QueryException e = (QueryException)t;
            for (Map.Entry<Predicate<QueryException>, Function<QueryException, ? extends QueryException>> entry : errorMessageMap.entrySet()) {
                if (!entry.getKey().test(e)) continue;
                return (RuntimeException)entry.getValue().apply(e);
            }
        }
        return t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
    }

    private static String quote(String s) {
        if (s.contains("`")) {
            throw InvalidArgumentException.fromMessage((String)("Value [" + RedactableArgument.redactMeta((Object)s) + "] may not contain backticks."));
        }
        return "`" + s + "`";
    }

    private static String quote(String ... components) {
        return Arrays.stream(components).map(AsyncQueryIndexManager::quote).collect(Collectors.joining("."));
    }

    private static String buildKeyspace(String bucket, Optional<String> scope, Optional<String> collection) {
        if (scope.isPresent() && collection.isPresent()) {
            return AsyncQueryIndexManager.quote(bucket, scope.get(), collection.get());
        }
        return AsyncQueryIndexManager.quote(bucket);
    }

    static enum QueryType {
        READ_ONLY,
        WRITE;

    }
}

