/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.java.Bucket;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.CRC32;

@Stability.Uncommitted
public class NodeLocatorHelper {
    private final AtomicReference<BucketConfig> bucketConfig = new AtomicReference();

    private NodeLocatorHelper(Bucket bucket, Duration waitUntilReadyDuration) {
        ConfigurationProvider configurationProvider;
        BucketConfig bc;
        if (waitUntilReadyDuration.getSeconds() > 0L) {
            bucket.waitUntilReady(waitUntilReadyDuration);
        }
        if ((bc = (configurationProvider = bucket.core().configurationProvider()).config().bucketConfig(bucket.name())) == null) {
            throw new CouchbaseException("Bucket configuration not found, if waitUntilReadyDuration is set to 0 the callmust be executed before initializing the NodeLocatorHelper!");
        }
        this.bucketConfig.set(configurationProvider.config().bucketConfig(bucket.name()));
        configurationProvider.configs().subscribe(cc -> {
            BucketConfig newConfig = cc.bucketConfig(bucket.name());
            if (newConfig != null) {
                this.bucketConfig.set(newConfig);
            }
        });
    }

    public static NodeLocatorHelper create(Bucket bucket, Duration waitUntilReadyDuration) {
        return new NodeLocatorHelper(bucket, waitUntilReadyDuration);
    }

    public String activeNodeForId(String id) {
        BucketConfig config = this.bucketConfig.get();
        if (config instanceof CouchbaseBucketConfig) {
            return NodeLocatorHelper.nodeForIdOnCouchbaseBucket(id, (CouchbaseBucketConfig)config);
        }
        if (config instanceof MemcachedBucketConfig) {
            return NodeLocatorHelper.nodeForIdOnMemcachedBucket(id, (MemcachedBucketConfig)config);
        }
        throw new UnsupportedOperationException("Bucket type not supported: " + config.getClass().getName());
    }

    public List<String> replicaNodesForId(String id) {
        BucketConfig config = this.bucketConfig.get();
        if (config instanceof CouchbaseBucketConfig) {
            CouchbaseBucketConfig cbc = (CouchbaseBucketConfig)config;
            ArrayList<String> replicas = new ArrayList<String>();
            for (int i = 1; i <= cbc.numberOfReplicas(); ++i) {
                replicas.add(this.replicaNodeForId(id, i));
            }
            return replicas;
        }
        throw new UnsupportedOperationException("Bucket type not supported: " + config.getClass().getName());
    }

    public String replicaNodeForId(String id, int replicaNum) {
        if (replicaNum < 1 || replicaNum > 3) {
            throw new IllegalArgumentException("Replica number must be between 1 and 3.");
        }
        BucketConfig config = this.bucketConfig.get();
        if (config instanceof CouchbaseBucketConfig) {
            CouchbaseBucketConfig cbc = (CouchbaseBucketConfig)config;
            int partitionId = (int)NodeLocatorHelper.hashId(id) & cbc.numberOfPartitions() - 1;
            short nodeId = cbc.nodeIndexForReplica(partitionId, replicaNum - 1, false);
            if (nodeId == -1) {
                throw new IllegalStateException("No partition assigned to node for Document ID: " + id);
            }
            if (nodeId == -2) {
                throw new IllegalStateException("Replica not configured for this bucket.");
            }
            return cbc.nodeAtIndex((int)nodeId).hostname();
        }
        throw new UnsupportedOperationException("Bucket type not supported: " + config.getClass().getName());
    }

    public List<String> nodes() {
        return this.bucketConfig.get().nodes().stream().map(NodeInfo::hostname).collect(Collectors.toList());
    }

    private static String nodeForIdOnCouchbaseBucket(String id, CouchbaseBucketConfig config) {
        int partitionId = (int)NodeLocatorHelper.hashId(id) & config.numberOfPartitions() - 1;
        short nodeId = config.nodeIndexForActive(partitionId, false);
        if (nodeId == -1) {
            throw new IllegalStateException("No partition assigned to node for Document ID: " + id);
        }
        return config.nodeAtIndex((int)nodeId).hostname();
    }

    private static String nodeForIdOnMemcachedBucket(String id, MemcachedBucketConfig config) {
        long hash = NodeLocatorHelper.ketamaHash(id);
        if (!config.ketamaNodes().containsKey(hash)) {
            SortedMap tailMap = config.ketamaNodes().tailMap(hash);
            hash = tailMap.isEmpty() ? ((Long)config.ketamaNodes().firstKey()).longValue() : tailMap.firstKey().longValue();
        }
        return ((NodeInfo)config.ketamaNodes().get(hash)).hostname();
    }

    private static long hashId(String id) {
        CRC32 crc32 = new CRC32();
        crc32.update(id.getBytes(StandardCharsets.UTF_8));
        return crc32.getValue() >> 16 & 0x7FFFL;
    }

    private static long ketamaHash(String key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(key.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md5.digest();
            long rv = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
            return rv & 0xFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not encode ketama hash - MD5 should be available in the JVM.", e);
        }
    }
}

