/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.manager.CoreBucketManager;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.bucket.CompressionMode;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@Stability.Volatile
public class AsyncBucketManager {
    private final CoreBucketManager coreBucketManager;

    public AsyncBucketManager(Core core) {
        this.coreBucketManager = new CoreBucketManager(core);
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings) {
        return this.createBucket(settings, CreateBucketOptions.createBucketOptions());
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings, CreateBucketOptions options) {
        return this.coreBucketManager.createBucket(this.toMap(settings), (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings) {
        return this.updateBucket(settings, UpdateBucketOptions.updateBucketOptions());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        return this.coreBucketManager.updateBucket(this.toMap(settings), (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> dropBucket(String bucketName) {
        return this.dropBucket(bucketName, DropBucketOptions.dropBucketOptions());
    }

    public CompletableFuture<Void> dropBucket(String bucketName, DropBucketOptions options) {
        return this.coreBucketManager.dropBucket(bucketName, (CoreCommonOptions)options.build());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName) {
        return this.getBucket(bucketName, GetBucketOptions.getBucketOptions());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName, GetBucketOptions options) {
        return this.coreBucketManager.getBucket(bucketName, (CoreCommonOptions)options.build()).thenApply(AsyncBucketManager.parseBucketSettings());
    }

    private static Function<byte[], BucketSettings> parseBucketSettings() {
        return bucketBytes -> {
            JsonNode tree = Mapper.decodeIntoTree((byte[])bucketBytes);
            return BucketSettings.create(tree);
        };
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets() {
        return this.getAllBuckets(GetAllBucketOptions.getAllBucketOptions());
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets(GetAllBucketOptions options) {
        return this.coreBucketManager.getAllBuckets((CoreCommonOptions)options.build()).thenApply(bucketNameToBytes -> CbCollections.transformValues((Map)bucketNameToBytes, AsyncBucketManager.parseBucketSettings()));
    }

    public CompletableFuture<Void> flushBucket(String bucketName) {
        return this.flushBucket(bucketName, FlushBucketOptions.flushBucketOptions());
    }

    public CompletableFuture<Void> flushBucket(String bucketName, FlushBucketOptions options) {
        return this.coreBucketManager.flushBucket(bucketName, (CoreCommonOptions)options.build());
    }

    private Map<String, String> toMap(BucketSettings settings) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ramQuotaMB", String.valueOf(settings.ramQuotaMB()));
        if (settings.bucketType() != BucketType.MEMCACHED) {
            params.put("replicaNumber", String.valueOf(settings.numReplicas()));
        }
        params.put("flushEnabled", String.valueOf(settings.flushEnabled() ? 1 : 0));
        long maxTTL = settings.maxExpiry().getSeconds();
        if (maxTTL != 0L) {
            params.put("maxTTL", String.valueOf(maxTTL));
        }
        if (settings.evictionPolicy() != null) {
            params.put("evictionPolicy", settings.evictionPolicy().alias());
        }
        if (settings.compressionMode() != CompressionMode.PASSIVE) {
            params.put("compressionMode", settings.compressionMode().alias());
        }
        if (settings.minimumDurabilityLevel() != DurabilityLevel.NONE) {
            params.put("durabilityMinLevel", settings.minimumDurabilityLevel().encodeForManagementApi());
        }
        params.put("name", settings.name());
        params.put("bucketType", settings.bucketType().alias());
        params.put("conflictResolutionType", settings.conflictResolutionType().alias());
        if (settings.bucketType() != BucketType.EPHEMERAL) {
            params.put("replicaIndex", String.valueOf(settings.replicaIndexes() ? 1 : 0));
        }
        return params;
    }
}

