/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.AppendRequest;
import com.couchbase.client.core.msg.kv.DecrementRequest;
import com.couchbase.client.core.msg.kv.IncrementRequest;
import com.couchbase.client.core.msg.kv.PrependRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.kv.AppendAccessor;
import com.couchbase.client.java.kv.AppendOptions;
import com.couchbase.client.java.kv.CounterAccessor;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DecrementOptions;
import com.couchbase.client.java.kv.IncrementOptions;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PrependAccessor;
import com.couchbase.client.java.kv.PrependOptions;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class AsyncBinaryCollection {
    static AppendOptions DEFAULT_APPEND_OPTIONS = AppendOptions.appendOptions();
    static PrependOptions DEFAULT_PREPEND_OPTIONS = PrependOptions.prependOptions();
    static IncrementOptions DEFAULT_INCREMENT_OPTIONS = IncrementOptions.incrementOptions();
    static DecrementOptions DEFAULT_DECREMENT_OPTIONS = DecrementOptions.decrementOptions();
    private final Core core;
    private final CoreContext coreContext;
    private final CoreEnvironment environment;
    private final CollectionIdentifier collectionIdentifier;

    AsyncBinaryCollection(Core core, CoreEnvironment environment, CollectionIdentifier collectionIdentifier) {
        this.core = core;
        this.coreContext = core.context();
        this.environment = environment;
        this.collectionIdentifier = collectionIdentifier;
    }

    public CompletableFuture<MutationResult> append(String id, byte[] content) {
        return this.append(id, content, DEFAULT_APPEND_OPTIONS);
    }

    public CompletableFuture<MutationResult> append(String id, byte[] content, AppendOptions options) {
        Validators.notNull((Object)options, (String)"AppendOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        AppendOptions.Built opts = options.build();
        return AppendAccessor.append(this.core, this.appendRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    AppendRequest appendRequest(String id, byte[] content, AppendOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("append", (RequestSpan)opts.parentSpan().orElse(null));
        AppendRequest request = new AppendRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, content, opts.cas(), opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<MutationResult> prepend(String id, byte[] content) {
        return this.prepend(id, content, DEFAULT_PREPEND_OPTIONS);
    }

    public CompletableFuture<MutationResult> prepend(String id, byte[] content, PrependOptions options) {
        Validators.notNull((Object)options, (String)"PrependOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        PrependOptions.Built opts = options.build();
        return PrependAccessor.prepend(this.core, this.prependRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    PrependRequest prependRequest(String id, byte[] content, PrependOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("prepend", (RequestSpan)opts.parentSpan().orElse(null));
        PrependRequest request = new PrependRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, content, opts.cas(), opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<CounterResult> increment(String id) {
        return this.increment(id, DEFAULT_INCREMENT_OPTIONS);
    }

    public CompletableFuture<CounterResult> increment(String id, IncrementOptions options) {
        Validators.notNull((Object)options, (String)"IncrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        IncrementOptions.Built opts = options.build();
        return CounterAccessor.increment(this.core, this.incrementRequest(id, opts), id, opts.persistTo(), opts.replicateTo());
    }

    IncrementRequest incrementRequest(String id, IncrementOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("increment", (RequestSpan)opts.parentSpan().orElse(null));
        long expiry = opts.expiry().encode(this.environment.eventBus());
        IncrementRequest request = new IncrementRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, opts.delta(), opts.initial(), expiry, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<CounterResult> decrement(String id) {
        return this.decrement(id, DEFAULT_DECREMENT_OPTIONS);
    }

    public CompletableFuture<CounterResult> decrement(String id, DecrementOptions options) {
        Validators.notNull((Object)options, (String)"DecrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        DecrementOptions.Built opts = options.build();
        return CounterAccessor.decrement(this.core, this.decrementRequest(id, opts), id, opts.persistTo(), opts.replicateTo());
    }

    DecrementRequest decrementRequest(String id, DecrementOptions.Built opts) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("decrement", (RequestSpan)opts.parentSpan().orElse(null));
        long expiry = opts.expiry().encode(this.environment.eventBus());
        DecrementRequest request = new DecrementRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, opts.delta(), opts.initial(), expiry, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    CollectionIdentifier collectionIdentifier() {
        return this.collectionIdentifier;
    }
}

