/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.util.Objects;
import java.util.Optional;

public class QueryIndex {
    private final String name;
    private final boolean primary;
    private final String state;
    private final String keyspace;
    private final String namespace;
    private final JsonArray indexKey;
    private final String type;
    private final Optional<String> condition;
    private final Optional<String> partition;
    private final JsonObject raw;

    public QueryIndex(JsonObject raw) {
        this.raw = Objects.requireNonNull(raw);
        this.name = raw.getString("name");
        this.state = raw.getString("state");
        this.keyspace = raw.getString("keyspace_id");
        this.namespace = raw.getString("namespace_id");
        this.indexKey = raw.getArray("index_key");
        this.condition = Optional.ofNullable(CbStrings.emptyToNull((String)raw.getString("condition")));
        this.primary = Boolean.TRUE.equals(raw.getBoolean("is_primary"));
        this.type = (String)CbObjects.defaultIfNull((Object)raw.getString("using"), (Object)"gsi");
        this.partition = Optional.ofNullable(CbStrings.emptyToNull((String)raw.getString("partition")));
    }

    public boolean primary() {
        return this.primary;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String state() {
        return this.state;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String namespace() {
        return this.namespace;
    }

    public JsonArray indexKey() {
        return this.indexKey;
    }

    public Optional<String> condition() {
        return this.condition;
    }

    public Optional<String> partition() {
        return this.partition;
    }

    public JsonObject raw() {
        return this.raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryIndex that = (QueryIndex)o;
        return this.raw.equals(that.raw);
    }

    public int hashCode() {
        return Objects.hash(this.raw);
    }

    public String toString() {
        return RedactableArgument.redactMeta((Object)this.raw).toString();
    }
}

