/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@Stability.Volatile
public class Role {
    private final String name;
    private final Optional<String> bucket;

    public Role(String roleName) {
        this(roleName, null);
    }

    @JsonCreator
    public Role(@JsonProperty(value="role") String roleName, @JsonProperty(value="bucket_name") String bucket) {
        this.name = Objects.requireNonNull(roleName);
        this.bucket = Optional.ofNullable(bucket);
    }

    public String name() {
        return this.name;
    }

    public Optional<String> bucket() {
        return this.bucket;
    }

    public String toString() {
        return this.format();
    }

    public String format() {
        return this.bucket().isPresent() ? this.name + "[" + this.bucket().get() + "]" : this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return this.name.equals(role.name) && Objects.equals(this.bucket, role.bucket);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.bucket);
    }
}

