/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import java.time.Duration;
import java.util.Optional;

public class IncrementOptions
extends CommonDurabilityOptions<IncrementOptions> {
    private long delta = 1L;
    private Optional<Long> initial = Optional.empty();
    private Duration expiry = Duration.ZERO;
    private long cas = 0L;

    public static IncrementOptions incrementOptions() {
        return new IncrementOptions();
    }

    private IncrementOptions() {
    }

    public IncrementOptions delta(long delta) {
        if (delta < 0L) {
            throw InvalidArgumentException.fromMessage((String)"The delta cannot be less than 0");
        }
        this.delta = delta;
        return this;
    }

    public IncrementOptions initial(long initial) {
        this.initial = Optional.of(initial);
        return this;
    }

    public IncrementOptions expiry(Duration expiry) {
        this.expiry = expiry;
        return this;
    }

    public IncrementOptions cas(long cas) {
        this.cas = cas;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonDurabilityOptions.BuiltCommonDurabilityOptions {
        Built() {
        }

        public Duration expiry() {
            return IncrementOptions.this.expiry;
        }

        public Optional<Long> initial() {
            return IncrementOptions.this.initial;
        }

        public long delta() {
            return IncrementOptions.this.delta;
        }

        public long cas() {
            return IncrementOptions.this.cas;
        }
    }
}

