/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetResult;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class GetReplicaResult
extends GetResult {
    private final boolean isReplica;

    private GetReplicaResult(byte[] content, int flags, long cas, Optional<Duration> expiry, Transcoder transcoder, boolean isReplica) {
        super(content, flags, cas, expiry, transcoder);
        this.isReplica = isReplica;
    }

    @Stability.Internal
    public static GetReplicaResult from(GetResult response, boolean isReplica) {
        return new GetReplicaResult(response.content, response.flags, response.cas(), response.expiry(), response.transcoder, isReplica);
    }

    public boolean isReplica() {
        return this.isReplica;
    }

    @Override
    public String toString() {
        return "GetReplicaResult{content=" + RedactableArgument.redactUser((Object)this.convertContentToString()) + ", flags=0x" + Integer.toHexString(this.flags) + ", cas=0x" + Long.toHexString(this.cas()) + ", expiry=" + this.expiry() + ", isReplica=" + this.isReplica + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetReplicaResult getResult = (GetReplicaResult)o;
        if (this.isReplica != getResult.isReplica) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.content, this.flags, this.cas(), this.expiry(), this.isReplica);
    }
}

