/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.element;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.deps.io.netty.util.internal.StringUtil;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.element.Element;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class UnionElement
implements Element {
    private final boolean all;
    private final String with;

    public UnionElement(boolean all) {
        this.all = all;
        this.with = null;
    }

    public UnionElement(boolean all, String with) {
        this.all = all;
        this.with = with;
    }

    public UnionElement(boolean all, Statement with) {
        this.all = all;
        this.with = with.toString();
    }

    @Override
    public String export() {
        StringBuilder sb = new StringBuilder();
        sb.append("UNION");
        if (this.all) {
            sb.append(" ALL");
        }
        if (!StringUtil.isNullOrEmpty(this.with)) {
            sb.append(" ");
            sb.append(this.with);
        }
        return sb.toString();
    }
}

