/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.java.document.Document;

@InterfaceAudience.Public
@InterfaceStability.Uncommitted
public class EntityDocument<T>
implements Document<T> {
    private String id;
    private long cas;
    private int expiry;
    private T content;
    private MutationToken mutationToken;

    private EntityDocument(String id, int expiry, T content, long cas, MutationToken mutationToken) {
        if (expiry < 0) {
            throw new IllegalArgumentException("The Document expiry must not be negative.");
        }
        this.id = id;
        this.expiry = expiry;
        this.content = content;
        this.cas = cas;
        this.mutationToken = mutationToken;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public T content() {
        return this.content;
    }

    @Override
    public long cas() {
        return this.cas;
    }

    @Override
    public int expiry() {
        return this.expiry;
    }

    @Override
    public MutationToken mutationToken() {
        return this.mutationToken;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", cas=").append(this.cas);
        sb.append(", expiry=").append(this.expiry);
        sb.append(", content=").append(this.content);
        sb.append(", mutationToken=").append(this.mutationToken);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDocument that = (EntityDocument)o;
        if (this.cas != that.cas) {
            return false;
        }
        if (this.expiry != that.expiry) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        return !(this.mutationToken == null ? that.mutationToken != null : !this.mutationToken.equals(that.mutationToken));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.cas ^ this.cas >>> 32);
        result = 31 * result + this.expiry;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.mutationToken != null ? this.mutationToken.hashCode() : 0);
        return result;
    }

    public static <T> EntityDocument<T> create(T content) {
        return EntityDocument.create(null, 0, content, 0L);
    }

    public static <T> EntityDocument<T> create(String id, T content) {
        return EntityDocument.create(id, 0, content, 0L);
    }

    public static <T> EntityDocument<T> create(String id, int expiry, T content) {
        return EntityDocument.create(id, expiry, content, 0L);
    }

    public static <T> EntityDocument<T> create(String id, T content, long cas) {
        return EntityDocument.create(id, 0, content, cas);
    }

    public static <T> EntityDocument<T> create(String id, int expiry, T content, long cas) {
        return new EntityDocument<T>(id, expiry, content, cas, null);
    }

    public static <T> EntityDocument<T> create(String id, int expiry, T content, long cas, MutationToken mutationToken) {
        return new EntityDocument<T>(id, expiry, content, cas, mutationToken);
    }
}

